"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedSearchEmbeddableBase = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _searchResponseWarnings = require("@kbn/search-response-warnings");
var _total_documents = require("../application/main/components/total_documents/total_documents");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const containerStyles = (0, _react2.css)`
  width: 100%;
  position: relative;
`;
const SavedSearchEmbeddableBase = ({
  isLoading,
  totalHitCount,
  prepend,
  append,
  dataTestSubj,
  interceptedWarnings,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: containerStyles,
    direction: "column",
    gutterSize: "xs",
    responsive: false,
    "data-test-subj": dataTestSubj
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute"
  }), Boolean(prepend || totalHitCount) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "xs",
    responsive: false,
    wrap: true
  }, Boolean(prepend) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, prepend), !!totalHitCount && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "toolBarTotalDocsText"
  }, /*#__PURE__*/_react.default.createElement(_total_documents.TotalDocuments, {
    totalHitCount: totalHitCount
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      minHeight: 0
    }
  }, children), Boolean(append) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, append), /*#__PURE__*/_react.default.createElement(_searchResponseWarnings.SearchResponseWarningsBadge, {
    warnings: interceptedWarnings !== null && interceptedWarnings !== void 0 ? interceptedWarnings : []
  }));
};
exports.SavedSearchEmbeddableBase = SavedSearchEmbeddableBase;