"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formatTopLevelObject = exports.formatRow = void 0;
var _react = _interopRequireWildcard(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
require("./row_formatter.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const TemplateComponent = ({
  defPairs
}) => {
  return /*#__PURE__*/_react.default.createElement("dl", {
    className: 'source dscTruncateByHeight'
  }, defPairs.map((pair, idx) => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: idx
  }, /*#__PURE__*/_react.default.createElement("dt", null, pair[0], !!pair[1] && ':'), /*#__PURE__*/_react.default.createElement("dd", {
    className: "rowFormatter__value"
    // eslint-disable-next-line react/no-danger
    ,
    dangerouslySetInnerHTML: {
      __html: pair[1]
    }
  }), ' ')));
};
const formatRow = (hit, dataView, shouldShowFieldHandler, maxEntries, fieldFormats) => {
  const pairs = (0, _discoverUtils.formatHit)(hit, dataView, shouldShowFieldHandler, maxEntries, fieldFormats);
  return /*#__PURE__*/_react.default.createElement(TemplateComponent, {
    defPairs: pairs
  });
};
exports.formatRow = formatRow;
const formatTopLevelObject = (row, fields, dataView, maxEntries) => {
  var _row$highlight;
  const highlights = (_row$highlight = row.highlight) !== null && _row$highlight !== void 0 ? _row$highlight : {};
  const highlightPairs = [];
  const sourcePairs = [];
  const sorted = Object.entries(fields).sort(([keyA], [keyB]) => keyA.localeCompare(keyB));
  sorted.forEach(([key, values]) => {
    var _fields$getByName;
    const field = dataView.getFieldByName(key);
    const displayKey = fields.getByName ? (_fields$getByName = fields.getByName(key)) === null || _fields$getByName === void 0 ? void 0 : _fields$getByName.displayName : undefined;
    const formatter = field ? dataView.getFormatterForField(field) : {
      convert: (v, ..._) => String(v)
    };
    if (!values.map) return;
    const formatted = values.map(val => formatter.convert(val, 'html', {
      field,
      hit: row
    })).join(', ');
    const pairs = highlights[key] ? highlightPairs : sourcePairs;
    pairs.push([displayKey ? displayKey : key, formatted, key]);
  });
  return /*#__PURE__*/_react.default.createElement(TemplateComponent, {
    defPairs: [...highlightPairs, ...sourcePairs].slice(0, maxEntries)
  });
};
exports.formatTopLevelObject = formatTopLevelObject;