"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocTableEmbeddable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
require("./index.scss");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _discoverUtils = require("@kbn/discover-utils");
var _tool_bar_pagination = require("./components/pager/tool_bar_pagination");
var _doc_table_wrapper = require("./doc_table_wrapper");
var _saved_search_embeddable_base = require("../../embeddable/saved_search_embeddable_base");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DocTableWrapperMemoized = /*#__PURE__*/(0, _react.memo)(_doc_table_wrapper.DocTableWrapper);
const DocTableEmbeddable = props => {
  const onUpdateRowsPerPage = props.onUpdateRowsPerPage;
  const tableWrapperRef = (0, _react.useRef)(null);
  const {
    curPageIndex,
    pageSize,
    totalPages,
    startIndex,
    hasNextPage,
    changePageIndex,
    changePageSize
  } = (0, _discoverUtils.usePager)({
    initialPageSize: typeof props.rowsPerPageState === 'number' && props.rowsPerPageState > 0 ? Math.min(props.rowsPerPageState, _tool_bar_pagination.MAX_ROWS_PER_PAGE_OPTION) : 50,
    totalItems: props.rows.length
  });
  const showPagination = totalPages !== 0;
  const scrollTop = (0, _react.useCallback)(() => {
    if (tableWrapperRef.current) {
      tableWrapperRef.current.scrollTo(0, 0);
    }
  }, []);
  const pageOfItems = (0, _react.useMemo)(() => props.rows.slice(startIndex, pageSize + startIndex), [pageSize, startIndex, props.rows]);
  const onPageChange = (0, _react.useCallback)(page => {
    scrollTop();
    changePageIndex(page);
  }, [changePageIndex, scrollTop]);
  const onPageSizeChange = (0, _react.useCallback)(size => {
    scrollTop();
    changePageSize(size);
    onUpdateRowsPerPage === null || onUpdateRowsPerPage === void 0 ? void 0 : onUpdateRowsPerPage(size); // to update `rowsPerPage` input param for the embeddable
  }, [changePageSize, scrollTop, onUpdateRowsPerPage]);
  const shouldShowLimitedResultsWarning = (0, _react.useMemo)(() => !hasNextPage && props.totalHitCount && props.rows.length < props.totalHitCount, [hasNextPage, props.rows.length, props.totalHitCount]);
  const renderDocTable = (0, _react.useCallback)(renderProps => {
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "kbnDocTable__container"
    }, /*#__PURE__*/_react.default.createElement("table", {
      className: "kbnDocTable table",
      "data-test-subj": "docTable"
    }, /*#__PURE__*/_react.default.createElement("thead", null, renderProps.renderHeader()), /*#__PURE__*/_react.default.createElement("tbody", null, renderProps.renderRows(pageOfItems))));
  }, [pageOfItems]);
  return /*#__PURE__*/_react.default.createElement(_saved_search_embeddable_base.SavedSearchEmbeddableBase, {
    interceptedWarnings: props.interceptedWarnings,
    totalHitCount: props.totalHitCount,
    isLoading: props.isLoading,
    prepend: shouldShowLimitedResultsWarning ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      grow: false,
      size: "s",
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.docTable.limitedSearchResultLabel",
      defaultMessage: "Limited to {resultCount} results. Refine your search.",
      values: {
        resultCount: props.sampleSizeState
      }
    })) : undefined,
    append: showPagination ? /*#__PURE__*/_react.default.createElement(_tool_bar_pagination.ToolBarPagination, {
      pageSize: pageSize,
      pageCount: totalPages,
      activePage: curPageIndex,
      onPageClick: onPageChange,
      onPageSizeChange: onPageSizeChange
    }) : undefined
  }, /*#__PURE__*/_react.default.createElement(DocTableWrapperMemoized, (0, _extends2.default)({
    ref: tableWrapperRef
  }, props, {
    render: renderDocTable
  })));
};
exports.DocTableEmbeddable = DocTableEmbeddable;