"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorCallout = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _public = require("@kbn/data-plugin/public");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _use_discover_services = require("../../hooks/use_discover_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ErrorCallout = ({
  title,
  error
}) => {
  var _overrideDisplay$titl, _overrideDisplay$acti, _overrideDisplay$body;
  const {
    core
  } = (0, _use_discover_services.useDiscoverServices)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const overrideDisplay = (0, _public.getSearchErrorOverrideDisplay)({
    error,
    application: core.application
  });
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "error",
    color: "danger",
    title: /*#__PURE__*/_react2.default.createElement("h2", {
      "data-test-subj": "discoverErrorCalloutTitle"
    }, (_overrideDisplay$titl = overrideDisplay === null || overrideDisplay === void 0 ? void 0 : overrideDisplay.title) !== null && _overrideDisplay$titl !== void 0 ? _overrideDisplay$titl : title),
    actions: (_overrideDisplay$acti = overrideDisplay === null || overrideDisplay === void 0 ? void 0 : overrideDisplay.actions) !== null && _overrideDisplay$acti !== void 0 ? _overrideDisplay$acti : [],
    body: /*#__PURE__*/_react2.default.createElement("div", {
      css: (0, _react.css)`
            text-align: left;
          `
    }, (_overrideDisplay$body = overrideDisplay === null || overrideDisplay === void 0 ? void 0 : overrideDisplay.body) !== null && _overrideDisplay$body !== void 0 ? _overrideDisplay$body : /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement("p", {
      css: (0, _react.css)`
                  white-space: break-spaces;
                  font-family: ${euiTheme.font.familyCode};
                `,
      "data-test-subj": "discoverErrorCalloutMessage"
    }, error.message), /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
      onClick: () => core.notifications.showErrorDialog({
        title,
        error
      })
    }, _i18n.i18n.translate('discover.errorCalloutShowErrorMessage', {
      defaultMessage: 'View details'
    }))))
  });
};
exports.ErrorCallout = ErrorCallout;