"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Doc = Doc;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _unifiedDocViewer = require("@kbn/unified-doc-viewer");
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _breadcrumbs = require("../../../utils/breadcrumbs");
var _use_discover_services = require("../../../hooks/use_discover_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function Doc(props) {
  const {
    dataView
  } = props;
  const [reqState, hit] = (0, _public.useEsDocSearch)(props);
  const services = (0, _use_discover_services.useDiscoverServices)();
  const {
    locator,
    chrome,
    docLinks
  } = services;
  const indexExistsLink = docLinks.links.apis.indexExists;
  (0, _react.useEffect)(() => {
    (0, _breadcrumbs.setBreadcrumbs)({
      services,
      titleBreadcrumbText: `${props.index}#${props.id}`,
      rootBreadcrumbPath: props.referrer
    });
  }, [chrome, props.referrer, props.index, props.id, dataView, locator, services]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, null, /*#__PURE__*/_react.default.createElement("h1", {
    id: "singleDocTitle",
    className: "euiScreenReaderOnly",
    "data-test-subj": "discoverSingleDocTitle"
  }, _i18n.i18n.translate('discover.doc.pageTitle', {
    defaultMessage: 'Single document - #{id}',
    values: {
      id: props.id
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    panelled: true,
    paddingSize: "m",
    panelProps: {
      role: 'main'
    }
  }, reqState === _unifiedDocViewer.ElasticRequestState.NotFoundDataView && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    "data-test-subj": `doc-msg-notFoundDataView`,
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.doc.failedToLocateDataView",
      defaultMessage: "No data view matches ID {dataViewId}.",
      values: {
        dataViewId: dataView.id
      }
    })
  }), reqState === _unifiedDocViewer.ElasticRequestState.NotFound && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    "data-test-subj": `doc-msg-notFound`,
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.doc.failedToLocateDocumentDescription",
      defaultMessage: "Cannot find document"
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.doc.couldNotFindDocumentsDescription",
    defaultMessage: "No documents match that ID."
  })), reqState === _unifiedDocViewer.ElasticRequestState.Error && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    "data-test-subj": `doc-msg-error`,
    iconType: "warning",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "discover.doc.failedToExecuteQueryDescription",
      defaultMessage: "Cannot run search"
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.doc.somethingWentWrongDescription",
    defaultMessage: "{indexName} is missing.",
    values: {
      indexName: props.index
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: indexExistsLink,
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.doc.somethingWentWrongDescriptionAddon",
    defaultMessage: "Please ensure the index exists."
  }))), reqState === _unifiedDocViewer.ElasticRequestState.Loading && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": `doc-msg-loading`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  }), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "discover.doc.loadingDescription",
    defaultMessage: "Loading\u2026"
  })), reqState === _unifiedDocViewer.ElasticRequestState.Found && hit !== null && dataView && /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "doc-hit"
  }, /*#__PURE__*/_react.default.createElement(_public.UnifiedDocViewer, {
    hit: hit,
    dataView: dataView,
    hideActionsColumn: true
  }))));
}