"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverAppLocatorDefinition = exports.DISCOVER_APP_LOCATOR = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _customizations = require("./customizations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const DISCOVER_APP_LOCATOR = 'DISCOVER_APP_LOCATOR';

/**
 * Location state of scoped history (history instance of Kibana Platform application service)
 */
exports.DISCOVER_APP_LOCATOR = DISCOVER_APP_LOCATOR;
class DiscoverAppLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", DISCOVER_APP_LOCATOR);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const {
        useHash = this.deps.useHash,
        filters,
        dataViewId,
        indexPatternId,
        dataViewSpec,
        query,
        refreshInterval,
        savedSearchId,
        timeRange,
        searchSessionId,
        columns,
        grid,
        savedQuery,
        sort,
        interval,
        viewMode,
        hideAggregatedPreview,
        breakdownField,
        isAlertResults,
        profile
      } = params;
      const savedSearchPath = savedSearchId ? `view/${encodeURIComponent(savedSearchId)}` : '';
      const appState = {};
      const queryState = {};
      const {
        isFilterPinned
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
      if (query) appState.query = query;
      if (filters && filters.length) appState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => !isFilterPinned(f));
      if (indexPatternId) appState.index = indexPatternId;
      if (dataViewId) appState.index = dataViewId;
      if (columns) appState.columns = columns;
      if (grid) appState.grid = grid;
      if (savedQuery) appState.savedQuery = savedQuery;
      if (sort) appState.sort = sort;
      if (interval) appState.interval = interval;
      if (timeRange) queryState.time = timeRange;
      if (filters && filters.length) queryState.filters = filters === null || filters === void 0 ? void 0 : filters.filter(f => isFilterPinned(f));
      if (refreshInterval) queryState.refreshInterval = refreshInterval;
      if (viewMode) appState.viewMode = viewMode;
      if (hideAggregatedPreview) appState.hideAggregatedPreview = hideAggregatedPreview;
      if (breakdownField) appState.breakdownField = breakdownField;
      const state = {};
      if (dataViewSpec) state.dataViewSpec = dataViewSpec;
      if (isAlertResults) state.isAlertResults = isAlertResults;
      let path = '#/';
      if (profile) {
        path = (0, _customizations.addProfile)(path, profile);
      }
      path = `${path}${savedSearchPath}`;
      if (searchSessionId) {
        path = `${path}?searchSessionId=${searchSessionId}`;
      }
      if (Object.keys(queryState).length) {
        path = this.deps.setStateToKbnUrl('_g', queryState, {
          useHash
        }, path);
      }
      if (Object.keys(appState).length) {
        path = this.deps.setStateToKbnUrl('_a', appState, {
          useHash
        }, path);
      }
      return {
        app: 'discover',
        path,
        state
      };
    });
    this.deps = deps;
  }
}
exports.DiscoverAppLocatorDefinition = DiscoverAppLocatorDefinition;