"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = renderApp;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _public = require("@kbn/kibana-react-plugin/public");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function DevToolsWrapper({
  devTools,
  activeDevTool,
  updateRoute,
  theme$,
  appServices,
  location
}) {
  const {
    docTitleService,
    breadcrumbService
  } = appServices;
  const mountedTool = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => () => {
    if (mountedTool.current) {
      mountedTool.current.unmountHandler();
    }
  }, []);
  (0, _react.useEffect)(() => {
    docTitleService.setTitle(activeDevTool.title);
    breadcrumbService.setBreadcrumbs(activeDevTool.title);
  }, [activeDevTool, docTitleService, breadcrumbService]);
  return /*#__PURE__*/_react.default.createElement("main", {
    className: "devApp"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    style: {
      paddingLeft: _uiTheme.euiThemeVars.euiSizeS
    },
    size: "l"
  }, devTools.map(currentDevTool => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: currentDevTool.id,
    disabled: currentDevTool.isDisabled(),
    isSelected: currentDevTool === activeDevTool,
    onClick: () => {
      if (!currentDevTool.isDisabled()) {
        updateRoute(`/${currentDevTool.id}`);
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: currentDevTool.tooltipContent
  }, /*#__PURE__*/_react.default.createElement("span", null, currentDevTool.title, ' ', currentDevTool.isBeta && /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    size: "s",
    className: "devApp__tabBeta",
    label: _i18n.i18n.translate('devTools.badge.betaLabel', {
      defaultMessage: 'Beta'
    })
  })))))), /*#__PURE__*/_react.default.createElement("div", {
    className: "devApp__container",
    role: "tabpanel",
    "data-test-subj": activeDevTool.id,
    ref: async element => {
      if (element && (mountedTool.current === null || mountedTool.current.devTool !== activeDevTool || mountedTool.current.mountpoint !== element)) {
        if (mountedTool.current) {
          mountedTool.current.unmountHandler();
        }
        const params = {
          element,
          location,
          theme$
        };
        const unmountHandler = await activeDevTool.mount(params);
        mountedTool.current = {
          devTool: activeDevTool,
          mountpoint: element,
          unmountHandler
        };
      }
    }
  }));
}
function redirectOnMissingCapabilities(application) {
  if (!application.capabilities.dev_tools.show) {
    application.navigateToApp('home');
    return true;
  }
  return false;
}
function setBadge(application, chrome) {
  if (application.capabilities.dev_tools.save) {
    return;
  }
  chrome.setBadge({
    text: _i18n.i18n.translate('devTools.badge.readOnly.text', {
      defaultMessage: 'Read only'
    }),
    tooltip: _i18n.i18n.translate('devTools.badge.readOnly.tooltip', {
      defaultMessage: 'Unable to save'
    }),
    iconType: 'glasses'
  });
}
function renderApp(element, application, chrome, history, theme$, devTools, appServices) {
  if (redirectOnMissingCapabilities(application)) {
    return () => {};
  }
  setBadge(application, chrome);
  _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.HashRouter, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, devTools
  // Only create routes for devtools that are not disabled
  .filter(devTool => !devTool.isDisabled()).map(devTool => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    key: devTool.id,
    path: `/${devTool.id}`,
    exact: !devTool.enableRouting,
    render: props => /*#__PURE__*/_react.default.createElement(DevToolsWrapper, {
      updateRoute: props.history.push,
      location: props.location,
      activeDevTool: devTool,
      devTools: devTools,
      theme$: theme$,
      appServices: appServices
    })
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/"
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: `/${devTools[0].id}`
  })))))), element);

  // dispatch synthetic hash change event to update hash history objects
  // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
  const unlisten = history.listen(() => {
    window.dispatchEvent(new HashChangeEvent('hashchange'));
  });
  return () => {
    chrome.docTitle.reset();
    _reactDom.default.unmountComponentAtNode(element);
    unlisten();
  };
}