"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamStat = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _integration = require("./integration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataStreamStat {
  constructor(dataStreamStat) {
    var _dataStreamStat$title;
    (0, _defineProperty2.default)(this, "name", void 0);
    (0, _defineProperty2.default)(this, "title", void 0);
    (0, _defineProperty2.default)(this, "size", void 0);
    (0, _defineProperty2.default)(this, "sizeBytes", void 0);
    (0, _defineProperty2.default)(this, "lastActivity", void 0);
    (0, _defineProperty2.default)(this, "integration", void 0);
    (0, _defineProperty2.default)(this, "malformedDocs", void 0);
    this.name = dataStreamStat.name;
    this.title = (_dataStreamStat$title = dataStreamStat.title) !== null && _dataStreamStat$title !== void 0 ? _dataStreamStat$title : dataStreamStat.name;
    this.size = dataStreamStat.size;
    this.sizeBytes = dataStreamStat.sizeBytes;
    this.lastActivity = dataStreamStat.lastActivity;
    this.integration = dataStreamStat.integration;
    this.malformedDocs = dataStreamStat.malformedDocs;
  }
  static create(dataStreamStat) {
    const [_type, dataset, namespace] = dataStreamStat.name.split('-');
    const dataStreamStatProps = {
      name: dataStreamStat.name,
      title: `${dataset}-${namespace}`,
      size: dataStreamStat.size,
      sizeBytes: dataStreamStat.size_bytes,
      lastActivity: dataStreamStat.last_activity,
      integration: dataStreamStat.integration ? _integration.Integration.create(dataStreamStat.integration) : undefined
    };
    return new DataStreamStat(dataStreamStatProps);
  }
}
exports.DataStreamStat = DataStreamStat;