"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerGridEmbeddableFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _constants = require("./constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class DataVisualizerGridEmbeddableFactory {
  constructor(getStartServices) {
    (0, _defineProperty2.default)(this, "type", _constants.DATA_VISUALIZER_GRID_EMBEDDABLE_TYPE);
    (0, _defineProperty2.default)(this, "grouping", [{
      id: 'data_visualizer_grid',
      getDisplayName: () => 'Data Visualizer Grid'
    }]);
    this.getStartServices = getStartServices;
  }
  async isEditable() {
    return false;
  }
  canCreateNew() {
    return false;
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.dataVisualizer.index.components.grid.displayName', {
      defaultMessage: 'Data visualizer grid'
    });
  }
  getDescription() {
    return _i18n.i18n.translate('xpack.dataVisualizer.index.components.grid.description', {
      defaultMessage: 'Visualize data'
    });
  }
  async getServices() {
    const [coreStart, pluginsStart] = await this.getStartServices();
    return [coreStart, pluginsStart];
  }
  async create(initialInput, parent) {
    const [coreStart, pluginsStart] = await this.getServices();
    const {
      DataVisualizerGridEmbeddable
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./grid_embeddable')));
    return new DataVisualizerGridEmbeddable(initialInput, [coreStart, pluginsStart], parent);
  }
}
exports.DataVisualizerGridEmbeddableFactory = DataVisualizerGridEmbeddableFactory;