"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerDataViewManagement = DataVisualizerDataViewManagement;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _kibana_context = require("../../../kibana_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function DataVisualizerDataViewManagement(props) {
  const {
    services: {
      dataViewFieldEditor,
      application
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const {
    useNewFieldsApi,
    currentDataView
  } = props;
  const dataViewFieldEditPermission = dataViewFieldEditor === null || dataViewFieldEditor === void 0 ? void 0 : dataViewFieldEditor.userPermissions.editIndexPattern();
  const canEditDataViewField = !!dataViewFieldEditPermission && useNewFieldsApi;
  const [isAddDataViewFieldPopoverOpen, setIsAddDataViewFieldPopoverOpen] = (0, _react.useState)(false);
  const closeFieldEditor = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    return () => {
      // Make sure to close the editor when unmounting
      if (closeFieldEditor.current) {
        closeFieldEditor.current();
      }
    };
  }, []);
  if (dataViewFieldEditor === undefined || !currentDataView || !canEditDataViewField) {
    return null;
  }
  const addField = () => {
    closeFieldEditor.current = dataViewFieldEditor.openEditor({
      ctx: {
        dataView: currentDataView
      },
      onSave: () => {
        const refresh = {
          lastRefresh: Date.now()
        };
        _mlDatePicker.mlTimefilterRefresh$.next(refresh);
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "s",
    isOpen: isAddDataViewFieldPopoverOpen,
    closePopover: () => {
      setIsAddDataViewFieldPopoverOpen(false);
    },
    ownFocus: true,
    "data-test-subj": "dataVisualizerDataViewManagementPopover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      color: "text",
      iconType: "boxesHorizontal",
      "data-test-subj": "dataVisualizerDataViewManagementButton",
      "aria-label": _i18n.i18n.translate('xpack.dataVisualizer.index.dataViewManagement.actionsPopoverLabel', {
        defaultMessage: 'Data view settings'
      }),
      onClick: () => {
        setIsAddDataViewFieldPopoverOpen(!isAddDataViewFieldPopoverOpen);
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    "data-test-subj": "dataVisualizerDataViewManagementMenu",
    size: "s",
    items: [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "add",
      icon: "indexOpen",
      "data-test-subj": "dataVisualizerAddDataViewFieldAction",
      onClick: () => {
        setIsAddDataViewFieldPopoverOpen(false);
        addField();
      }
    }, _i18n.i18n.translate('xpack.dataVisualizer.index.dataViewManagement.addFieldButton', {
      defaultMessage: 'Add field to data view'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "manage",
      icon: "indexSettings",
      "data-test-subj": "dataVisualizerManageDataViewAction",
      onClick: () => {
        var _props$currentDataVie;
        setIsAddDataViewFieldPopoverOpen(false);
        application.navigateToApp('management', {
          path: `/kibana/dataViews/dataView/${(_props$currentDataVie = props.currentDataView) === null || _props$currentDataVie === void 0 ? void 0 : _props$currentDataVie.id}`
        });
      }
    }, _i18n.i18n.translate('xpack.dataVisualizer.index.dataViewManagement.manageFieldButton', {
      defaultMessage: 'Manage data view fields'
    }))]
  }));
}