"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LINES_TO_SAMPLE_VALUE_MIN = exports.LINES_TO_SAMPLE_VALUE_MAX = void 0;
exports.convertDelimiter = convertDelimiter;
exports.convertDelimiterBack = convertDelimiterBack;
exports.getColumnNames = getColumnNames;
exports.getGrokFieldNames = getGrokFieldNames;
exports.isLinesToSampleValid = isLinesToSampleValid;
var _grok_pattern = require("../../../common/util/grok_pattern");
var _option_lists = require("./options/option_lists");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LINES_TO_SAMPLE_VALUE_MIN = 3;
exports.LINES_TO_SAMPLE_VALUE_MIN = LINES_TO_SAMPLE_VALUE_MIN;
const LINES_TO_SAMPLE_VALUE_MAX = 1000000;

// Some delimiter characters cannot be used as items in select list.
// so show a textual description of the character instead.
exports.LINES_TO_SAMPLE_VALUE_MAX = LINES_TO_SAMPLE_VALUE_MAX;
function convertDelimiter(d) {
  switch (d) {
    case ',':
      return {
        delimiter: 'comma'
      };
    case '\t':
      return {
        delimiter: 'tab'
      };
    case ';':
      return {
        delimiter: 'semicolon'
      };
    case '|':
      return {
        delimiter: 'pipe'
      };
    case ' ':
      return {
        delimiter: 'space'
      };
    default:
      return {
        delimiter: _option_lists.CUSTOM_DROPDOWN_OPTION,
        customDelimiter: d
      };
  }
}

// Convert the delimiter textual descriptions back to their real characters.
function convertDelimiterBack(delimiter, customDelimiter) {
  switch (delimiter) {
    case 'comma':
      return ',';
    case 'tab':
      return '\t';
    case 'semicolon':
      return ';';
    case 'pipe':
      return '|';
    case 'space':
      return ' ';
    case _option_lists.CUSTOM_DROPDOWN_OPTION:
      return customDelimiter;
    default:
      return undefined;
  }
}
function getColumnNames(columnNames, originalSettings) {
  const newColumnNames = columnNames === undefined && originalSettings.columnNames !== undefined ? [...originalSettings.columnNames] : columnNames;
  const originalColumnNames = newColumnNames !== undefined ? [...newColumnNames] : [];
  return {
    newColumnNames,
    originalColumnNames
  };
}
function getGrokFieldNames(grokPattern, originalGrokPattern) {
  if (originalGrokPattern === undefined) {
    return [];
  }
  if (grokPattern === undefined) {
    return (0, _grok_pattern.getFieldsFromGrokPattern)(originalGrokPattern).map(f => f.name);
  }
  return (0, _grok_pattern.getFieldsFromGrokPattern)(grokPattern).map(f => f.name);
}
function isLinesToSampleValid(linesToSample) {
  return linesToSample > LINES_TO_SAMPLE_VALUE_MIN && linesToSample <= LINES_TO_SAMPLE_VALUE_MAX;
}