"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WelcomeContent = void 0;
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _kibana_context = require("../../../kibana_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WelcomeContent = ({
  hasPermissionToImport
}) => {
  const {
    services: {
      fileUpload: {
        getMaxBytesFormatted
      }
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const maxFileSize = getMaxBytesFormatted();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xl",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xxl",
    type: "addDataApp",
    className: "file-datavisualizer-about-panel__icon"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.welcomeContent.visualizeDataFromLogFileTitle",
    defaultMessage: "Visualize data from a log file"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, hasPermissionToImport ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.welcomeContent.visualizeAndImportDataFromLogFileDescription",
    defaultMessage: "Upload your file, analyze its data, and optionally import the data into an Elasticsearch index."
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.welcomeContent.visualizeDataFromLogFileDescription",
    defaultMessage: "Upload your file and analyze its data."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.welcomeContent.supportedFileFormatDescription",
    defaultMessage: "The following file formats are supported:"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "file-datavisualizer-about-panel__doc-icon"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "document"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.welcomeContent.delimitedTextFilesDescription",
    defaultMessage: "Delimited text files, such as CSV and TSV"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "file-datavisualizer-about-panel__doc-icon"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "document"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.welcomeContent.newlineDelimitedJsonDescription",
    defaultMessage: "Newline-delimited JSON"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    className: "file-datavisualizer-about-panel__doc-icon"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "document"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.welcomeContent.logFilesWithCommonFormatDescription",
    defaultMessage: "Log files with a common format for the timestamp"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.file.welcomeContent.uploadedFilesAllowedSizeDescription",
    defaultMessage: "You can upload files up to {maxFileSize}.",
    values: {
      maxFileSize
    }
  })))));
};
exports.WelcomeContent = WelcomeContent;