"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useTimeBuckets = void 0;
var _react = require("react");
var _dataService = require("@kbn/data-service");
var _time_buckets = require("../../../../common/services/time_buckets");
var _kibana_context = require("../../kibana_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useTimeBuckets = () => {
  const {
    uiSettings
  } = (0, _kibana_context.useDataVisualizerKibana)().services;
  return (0, _react.useMemo)(() => {
    return new _time_buckets.TimeBuckets({
      [_dataService.UI_SETTINGS.HISTOGRAM_MAX_BARS]: uiSettings.get(_dataService.UI_SETTINGS.HISTOGRAM_MAX_BARS),
      [_dataService.UI_SETTINGS.HISTOGRAM_BAR_TARGET]: uiSettings.get(_dataService.UI_SETTINGS.HISTOGRAM_BAR_TARGET),
      dateFormat: uiSettings.get('dateFormat'),
      'dateFormat:scaled': uiSettings.get('dateFormat:scaled')
    });
  }, [uiSettings]);
};
exports.useTimeBuckets = useTimeBuckets;