"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BooleanContentPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _utils = require("../../utils");
var _column_chart = require("./column_chart");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BooleanContentPreview = ({
  config
}) => {
  const chartData = (0, _react.useMemo)(() => {
    const results = (0, _utils.getTFPercentage)(config);
    if (results) {
      const data = [{
        key: 'true',
        key_as_string: 'true',
        doc_count: results.trueCount
      }, {
        key: 'false',
        key_as_string: 'false',
        doc_count: results.falseCount
      }];
      return {
        id: config.fieldName,
        cardinality: 2,
        data,
        type: 'boolean'
      };
    }
  }, [config]);
  if (!chartData || config.fieldName === undefined) return null;
  const columnType = {
    id: config.fieldName,
    schema: undefined
  };
  const dataTestSubj = `dataVisualizerDataGridChart-${config.fieldName}`;
  return /*#__PURE__*/_react.default.createElement(_column_chart.ColumnChart, {
    dataTestSubj: dataTestSubj,
    chartData: chartData,
    columnType: columnType,
    hideLabel: true,
    maxChartColumns: 10
  });
};
exports.BooleanContentPreview = BooleanContentPreview;