"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataVisualizerFieldTypesFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _fieldUtils = require("@kbn/field-utils");
var _field_types_help_popover = require("./field_types_help_popover");
var _multi_select_picker = require("../multi_select_picker");
var _field_type_icon = require("../field_type_icon");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataVisualizerFieldTypesFilter = ({
  fields,
  setVisibleFieldTypes,
  visibleFieldTypes
}) => {
  const fieldNameTitle = (0, _react.useMemo)(() => _i18n.i18n.translate('xpack.dataVisualizer.fieldTypeSelect', {
    defaultMessage: 'Field type'
  }), []);
  const options = (0, _react.useMemo)(() => {
    const fieldTypesTracker = new Set();
    const fieldTypes = [];
    fields.forEach(({
      type
    }) => {
      const label = (0, _fieldUtils.getFieldTypeName)(type);
      if (type !== undefined && !fieldTypesTracker.has(type) && label !== undefined) {
        fieldTypesTracker.add(type);
        fieldTypes.push({
          value: type,
          name: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: true
          }, " ", label), type && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false
          }, /*#__PURE__*/_react.default.createElement(_field_type_icon.FieldTypeIcon, {
            type: type,
            tooltipEnabled: false
          })))
        });
      }
    });
    return fieldTypes;
  }, [fields]);
  return /*#__PURE__*/_react.default.createElement(_multi_select_picker.MultiSelectPicker, {
    title: fieldNameTitle,
    options: options,
    onChange: setVisibleFieldTypes,
    checkedOptions: visibleFieldTypes,
    dataTestSubj: 'dataVisualizerFieldTypeSelect',
    postfix: /*#__PURE__*/_react.default.createElement(_field_types_help_popover.FieldTypesHelpPopover, {
      fieldTypes: options.map(f => f.value)
    })
  });
};
exports.DataVisualizerFieldTypesFilter = DataVisualizerFieldTypesFilter;