"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "DATA_VIEW_PATH", {
  enumerable: true,
  get: function () {
    return _constants.DATA_VIEW_PATH;
  }
});
Object.defineProperty(exports, "DATA_VIEW_PATH_LEGACY", {
  enumerable: true,
  get: function () {
    return _constants.DATA_VIEW_PATH_LEGACY;
  }
});
Object.defineProperty(exports, "DATA_VIEW_SWAP_REFERENCES_PATH", {
  enumerable: true,
  get: function () {
    return _constants.DATA_VIEW_SWAP_REFERENCES_PATH;
  }
});
Object.defineProperty(exports, "DataView", {
  enumerable: true,
  get: function () {
    return _data_views.DataView;
  }
});
Object.defineProperty(exports, "DataViewsService", {
  enumerable: true,
  get: function () {
    return _data_views.DataViewsService;
  }
});
Object.defineProperty(exports, "IndexPatternsFetcher", {
  enumerable: true,
  get: function () {
    return _fetcher.IndexPatternsFetcher;
  }
});
Object.defineProperty(exports, "RUNTIME_FIELD_PATH", {
  enumerable: true,
  get: function () {
    return _constants.RUNTIME_FIELD_PATH;
  }
});
Object.defineProperty(exports, "RUNTIME_FIELD_PATH_LEGACY", {
  enumerable: true,
  get: function () {
    return _constants.RUNTIME_FIELD_PATH_LEGACY;
  }
});
Object.defineProperty(exports, "SCRIPTED_FIELD_PATH", {
  enumerable: true,
  get: function () {
    return _constants.SCRIPTED_FIELD_PATH;
  }
});
Object.defineProperty(exports, "SCRIPTED_FIELD_PATH_LEGACY", {
  enumerable: true,
  get: function () {
    return _constants.SCRIPTED_FIELD_PATH_LEGACY;
  }
});
Object.defineProperty(exports, "SERVICE_KEY", {
  enumerable: true,
  get: function () {
    return _constants.SERVICE_KEY;
  }
});
Object.defineProperty(exports, "SERVICE_KEY_LEGACY", {
  enumerable: true,
  get: function () {
    return _constants.SERVICE_KEY_LEGACY;
  }
});
Object.defineProperty(exports, "SERVICE_PATH", {
  enumerable: true,
  get: function () {
    return _constants.SERVICE_PATH;
  }
});
Object.defineProperty(exports, "SERVICE_PATH_LEGACY", {
  enumerable: true,
  get: function () {
    return _constants.SERVICE_PATH_LEGACY;
  }
});
Object.defineProperty(exports, "SPECIFIC_DATA_VIEW_PATH", {
  enumerable: true,
  get: function () {
    return _constants.SPECIFIC_DATA_VIEW_PATH;
  }
});
Object.defineProperty(exports, "SPECIFIC_DATA_VIEW_PATH_LEGACY", {
  enumerable: true,
  get: function () {
    return _constants.SPECIFIC_DATA_VIEW_PATH_LEGACY;
  }
});
Object.defineProperty(exports, "SPECIFIC_RUNTIME_FIELD_PATH", {
  enumerable: true,
  get: function () {
    return _constants.SPECIFIC_RUNTIME_FIELD_PATH;
  }
});
Object.defineProperty(exports, "SPECIFIC_RUNTIME_FIELD_PATH_LEGACY", {
  enumerable: true,
  get: function () {
    return _constants.SPECIFIC_RUNTIME_FIELD_PATH_LEGACY;
  }
});
Object.defineProperty(exports, "SPECIFIC_SCRIPTED_FIELD_PATH", {
  enumerable: true,
  get: function () {
    return _constants.SPECIFIC_SCRIPTED_FIELD_PATH;
  }
});
Object.defineProperty(exports, "SPECIFIC_SCRIPTED_FIELD_PATH_LEGACY", {
  enumerable: true,
  get: function () {
    return _constants.SPECIFIC_SCRIPTED_FIELD_PATH_LEGACY;
  }
});
exports.config = void 0;
Object.defineProperty(exports, "findIndexPatternById", {
  enumerable: true,
  get: function () {
    return _utils.findIndexPatternById;
  }
});
Object.defineProperty(exports, "getCapabilitiesForRollupIndices", {
  enumerable: true,
  get: function () {
    return _fetcher.getCapabilitiesForRollupIndices;
  }
});
Object.defineProperty(exports, "getFieldByName", {
  enumerable: true,
  get: function () {
    return _utils.getFieldByName;
  }
});
exports.plugin = plugin;
var _configSchema = require("@kbn/config-schema");
var _utils = require("./utils");
var _fetcher = require("./fetcher");
var _constants = require("./constants");
var _data_views = require("../common/data_views");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
/**
 * Static code to be shared externally
 * @public
 */

async function plugin(initializerContext) {
  const {
    DataViewsServerPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new DataViewsServerPlugin(initializerContext);
}
const configSchema = _configSchema.schema.object({
  scriptedFieldsEnabled: _configSchema.schema.conditional(_configSchema.schema.contextRef('serverless'), true, _configSchema.schema.boolean({
    defaultValue: false
  }), _configSchema.schema.never())
});
const config = {
  schema: configSchema,
  exposeToBrowser: {
    scriptedFieldsEnabled: true
  }
};
exports.config = config;