"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDeprecatedScriptingLanguages = getDeprecatedScriptingLanguages;
exports.getEnabledScriptingLanguages = void 0;
exports.getSupportedScriptingLanguages = getSupportedScriptingLanguages;
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/data-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getSupportedScriptingLanguages() {
  return ['painless'];
}
function getDeprecatedScriptingLanguages() {
  return [];
}
const getEnabledScriptingLanguages = (http, toasts) => http.get('/internal/scripts/languages', {
  version: _common.SCRIPT_LANGUAGES_ROUTE_LATEST_VERSION
}).catch(() => {
  toasts.addDanger(_i18n.i18n.translate('indexPatternManagement.scriptingLanguages.errorFetchingToastDescription', {
    defaultMessage: 'Error getting available scripting languages from Elasticsearch'
  }));
  return [];
});
exports.getEnabledScriptingLanguages = getEnabledScriptingLanguages;