"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFlyoutPanelsContext = exports.Panels = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
require("./flyout_panels.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

let idx = 0;
const panelId = () => idx++;
const flyoutPanelsContext = /*#__PURE__*/(0, _react.createContext)({
  addPanel() {
    return {
      removePanel: () => {},
      isFixedWidth: false
    };
  }
});
const limitWidthToWindow = (width, {
  innerWidth
}) => Math.min(width, innerWidth * 0.8);
const Panels = ({
  maxWidth,
  flyoutClassName,
  fixedPanelWidths = false,
  ...props
}) => {
  const flyoutDOMelement = (0, _react.useMemo)(() => {
    const el = document.getElementsByClassName(flyoutClassName);
    if (el.length === 0) {
      return null;
    }
    return el.item(0);
  }, [flyoutClassName]);
  const [panels, setPanels] = (0, _react.useState)({});
  const removePanel = (0, _react.useCallback)(id => {
    setPanels(prev => {
      const {
        [id]: panelToRemove,
        ...rest
      } = prev;
      return rest;
    });
  }, []);
  const addPanel = (0, _react.useCallback)(panel => {
    const nextId = panelId();
    setPanels(prev => {
      return {
        ...prev,
        [nextId]: panel
      };
    });
    return {
      removePanel: removePanel.bind(null, nextId),
      isFixedWidth: fixedPanelWidths
    };
  }, [removePanel, fixedPanelWidths]);
  const ctx = (0, _react.useMemo)(() => ({
    addPanel
  }), [addPanel]);
  (0, _react.useLayoutEffect)(() => {
    if (!flyoutDOMelement) {
      return;
    }
    let currentWidth;
    if (typeof maxWidth === 'number') {
      if (fixedPanelWidths) {
        const totalWidth = Object.values(panels).reduce((acc, {
          width = 0
        }) => acc + width, 0);
        currentWidth = Math.min(maxWidth, totalWidth);
        // As EUI declares both min-width and max-width on the .euiFlyout CSS class
        // we need to override  both values
        flyoutDOMelement.style.minWidth = `${limitWidthToWindow(currentWidth, window)}px`;
        flyoutDOMelement.style.maxWidth = `${limitWidthToWindow(currentWidth, window)}px`;
      } else {
        const totalPercentWidth = Math.min(100, Object.values(panels).reduce((acc, {
          width = 0
        }) => acc + width, 0));
        currentWidth = maxWidth * totalPercentWidth / 100;
        flyoutDOMelement.style.maxWidth = `${limitWidthToWindow(currentWidth, window)}px`;
      }
    } else {
      // maxWidth is false on smaller mobile screens when the preview panel is unused.
      // Unset custom min/max widths and let EUI's default 90vw width be used
      flyoutDOMelement.style.minWidth = '';
      flyoutDOMelement.style.maxWidth = '';
    }
  }, [panels, maxWidth, fixedPanelWidths, flyoutClassName, flyoutDOMelement]);
  return /*#__PURE__*/_react.default.createElement(flyoutPanelsContext.Provider, {
    value: ctx
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, (0, _extends2.default)({
    className: "fieldEditor__flyoutPanels",
    gutterSize: "none"
  }, props)));
};
exports.Panels = Panels;
const useFlyoutPanelsContext = () => {
  const ctx = (0, _react.useContext)(flyoutPanelsContext);
  if (ctx === undefined) {
    throw new Error('<Panel /> must be used within a <Panels /> wrapper');
  }
  return ctx;
};
exports.useFlyoutPanelsContext = useFlyoutPanelsContext;