"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormatEditorSamples = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
require("./samples.scss");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class FormatEditorSamples extends _react.PureComponent {
  render() {
    const {
      samples,
      sampleType
    } = this.props;
    const columns = [{
      field: 'input',
      name: _i18n.i18n.translate('indexPatternFieldEditor.samples.inputHeader', {
        defaultMessage: 'Input'
      }),
      render: input => {
        return typeof input === 'object' ? JSON.stringify(input) : input;
      }
    }, {
      field: 'output',
      name: _i18n.i18n.translate('indexPatternFieldEditor.samples.outputHeader', {
        defaultMessage: 'Output'
      }),
      render: output => {
        return sampleType === 'html' ? /*#__PURE__*/_react.default.createElement("div", {
          /*
           * Justification for dangerouslySetInnerHTML:
           * Sample output may contain HTML tags, like URL image/audio format.
           */
          dangerouslySetInnerHTML: {
            __html: output
          } // eslint-disable-line react/no-danger
        }) : /*#__PURE__*/_react.default.createElement("div", null, output);
      }
    }];
    return samples.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "indexPatternFieldEditor.samplesHeader",
        defaultMessage: "Samples"
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      className: "kbnFieldFormatEditor__samples",
      compressed: true,
      items: samples,
      columns: columns
    })) : null;
  }
}
exports.FormatEditorSamples = FormatEditorSamples;
(0, _defineProperty2.default)(FormatEditorSamples, "defaultProps", {
  sampleType: 'text'
});