"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewEditorPlugin = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _open_editor = require("./open_editor");
var _data_view_editor = require("./components/data_view_editor");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class DataViewEditorPlugin {
  setup(core, plugins) {
    return {};
  }
  start(core, plugins) {
    const {
      application,
      uiSettings,
      docLinks,
      http,
      notifications,
      overlays
    } = core;
    const {
      data,
      dataViews
    } = plugins;
    return {
      /**
       * Data view editor flyout via function interface
       * @param DataViewEditorProps - data view editor config
       * @returns method to close editor
       */
      openEditor: (0, _open_editor.getEditorOpener)({
        core,
        dataViews,
        searchClient: data.search.search
      }),
      /**
       * Data view editor flyout via react component
       * @param DataViewEditorProps - data view editor config
       * @returns JSX.Element
       */
      IndexPatternEditorComponent: props => /*#__PURE__*/_react.default.createElement(_data_view_editor.DataViewEditor, (0, _extends2.default)({
        services: {
          uiSettings,
          docLinks,
          http,
          notifications,
          application,
          overlays,
          dataViews,
          searchClient: data.search.search
        }
      }, props)),
      /**
       * Convenience method to determine whether the user can create or edit edit data views.
       *
       * @returns boolean
       */
      userPermissions: {
        editDataView: () => dataViews.getCanSaveSync()
      },
      /**
       * Helper method to generate a new data view editor service.
       * @returns DataViewEditorService
       */
      dataViewEditorServiceFactory: async () => {
        const module = await Promise.resolve().then(() => _interopRequireWildcard(require('./data_view_editor_service_lazy')));
        return module;
      }
    };
  }
}
exports.DataViewEditorPlugin = DataViewEditorPlugin;