"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../shared_imports");
var _data_view_editor_flyout_content = require("./data_view_editor_flyout_content");
var _data_view_editor_service = require("../data_view_editor_service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DataViewFlyoutContentContainer = ({
  onSave,
  onCancel = () => {},
  defaultTypeIsRollup,
  requireTimestampField = false,
  editData,
  allowAdHocDataView,
  showManagementLink
}) => {
  const {
    services: {
      dataViews,
      notifications,
      http
    }
  } = (0, _shared_imports.useKibana)();
  const [dataViewEditorService] = (0, _react.useState)(() => new _data_view_editor_service.DataViewEditorService({
    services: {
      http,
      dataViews
    },
    initialValues: {
      name: editData === null || editData === void 0 ? void 0 : editData.name,
      type: editData === null || editData === void 0 ? void 0 : editData.type,
      indexPattern: editData === null || editData === void 0 ? void 0 : editData.getIndexPattern()
    },
    requireTimestampField
  }));
  (0, _react.useEffect)(() => {
    const service = dataViewEditorService;
    return service.destroy;
  }, [dataViewEditorService]);
  const onSaveClick = async (dataViewSpec, persist = true) => {
    try {
      let saveResponse;
      if (editData) {
        const {
          name = '',
          timeFieldName,
          title = '',
          allowHidden = false
        } = dataViewSpec;
        editData.setIndexPattern(title);
        editData.name = name;
        editData.timeFieldName = timeFieldName;
        editData.setAllowHidden(allowHidden);
        saveResponse = editData.isPersisted() ? await dataViews.updateSavedObject(editData) : editData;
      } else {
        saveResponse = persist ? await dataViews.createAndSave(dataViewSpec) : await dataViews.create(dataViewSpec);
      }
      if (saveResponse && !(saveResponse instanceof Error)) {
        await dataViews.refreshFields(saveResponse);
        if (persist) {
          const title = _i18n.i18n.translate('indexPatternEditor.saved', {
            defaultMessage: 'Saved'
          });
          const text = `'${saveResponse.getName()}'`;
          notifications.toasts.addSuccess({
            title,
            text
          });
        }
        await onSave(saveResponse);
      }
    } catch (e) {
      const title = _i18n.i18n.translate('indexPatternEditor.dataView.unableSaveLabel', {
        defaultMessage: 'Failed to save data view.'
      });
      notifications.toasts.addDanger({
        title
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_data_view_editor_flyout_content.IndexPatternEditorFlyoutContent, {
    onSave: onSaveClick,
    onCancel: onCancel,
    defaultTypeIsRollup: defaultTypeIsRollup,
    editData: editData,
    showManagementLink: showManagementLink,
    allowAdHoc: allowAdHocDataView || false,
    dataViewEditorService: dataViewEditorService
  });
};

/* eslint-disable import/no-default-export */
var _default = DataViewFlyoutContentContainer;
exports.default = _default;
module.exports = exports.default;