"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStatusFilter = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _ = require("..");
var _status = require("../status");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getStatusFilter = tableData => ({
  type: 'field_value_selection',
  name: _i18n.i18n.translate('data.mgmt.searchSessions.search.filterStatus', {
    defaultMessage: 'Status'
  }),
  field: 'status',
  multiSelect: 'or',
  options: [...new Set(tableData.map(data => {
    var _data$status;
    return (_data$status = data.status) !== null && _data$status !== void 0 ? _data$status : 'unknown';
  }))].sort().map(status => ({
    value: status,
    view: /*#__PURE__*/_react.default.createElement(_.TableText, null, (0, _status.getStatusText)(status))
  }))
});
exports.getStatusFilter = getStatusFilter;