"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PopoverActionsMenu = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _get_action = require("./get_action");
var _types = require("./types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PopoverActionsMenu = ({
  api,
  onActionComplete,
  session,
  core
}) => {
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onPopoverClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const renderPopoverButton = () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: _i18n.i18n.translate('data.mgmt.searchSessions.actions.tooltip.moreActions', {
      defaultMessage: 'More actions'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('data.mgmt.searchSessions.ariaLabel.moreActions', {
      defaultMessage: 'More actions'
    }),
    color: "text",
    iconType: "boxesHorizontal",
    onClick: onPopoverClick
  }));
  const actions = session.actions || [];
  // Generic set of actions - up to the API to return what is available
  const items = actions.reduce((itemSet, actionType) => {
    const actionDef = (0, _get_action.getAction)(api, actionType, session, core);
    if (actionDef) {
      const {
        label,
        iconType,
        onClick
      } = actionDef;

      // add a line above the delete action (when there are multiple)
      // NOTE: Delete action MUST be the final action[] item
      if (actions.length > 1 && actionType === _types.ACTION.DELETE) {
        itemSet.push({
          isSeparator: true,
          key: 'separadorable'
        });
      }
      return [...itemSet, {
        key: `action-${actionType}`,
        name: label,
        icon: iconType,
        'data-test-subj': `sessionManagementPopoverAction-${actionType}`,
        onClick: async () => {
          closePopover();
          await onClick();
          onActionComplete();
        }
      }];
    }
    return itemSet;
  }, []);
  const panels = [{
    id: 0,
    items
  }];
  return actions.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: `popover-${session.id}`,
    button: renderPopoverButton(),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "downLeft",
    panelPaddingSize: 's'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels
  })) : null;
};
exports.PopoverActionsMenu = PopoverActionsMenu;