"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardContainerFactoryDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _ = require("..");
var _dashboard_constants = require("../../dashboard_constants");
var _common = require("../../../common");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class DashboardContainerFactoryDefinition {
  constructor(persistableStateService) {
    (0, _defineProperty2.default)(this, "isContainerType", true);
    (0, _defineProperty2.default)(this, "type", _.DASHBOARD_CONTAINER_TYPE);
    (0, _defineProperty2.default)(this, "inject", void 0);
    (0, _defineProperty2.default)(this, "extract", void 0);
    (0, _defineProperty2.default)(this, "isEditable", async () => {
      // Currently unused for dashboards
      return false;
    });
    (0, _defineProperty2.default)(this, "getDisplayName", () => {
      return _i18n.i18n.translate('dashboard.factory.displayName', {
        defaultMessage: 'Dashboard'
      });
    });
    (0, _defineProperty2.default)(this, "create", async (initialInput, parent, creationOptions, savedObjectId) => {
      const dashboardCreationStartTime = performance.now();
      const {
        createDashboard
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./create/create_dashboard')));
      try {
        const dashboard = await createDashboard(creationOptions, dashboardCreationStartTime, savedObjectId);
        return dashboard;
      } catch (e) {
        return new _public.ErrorEmbeddable(e, {
          id: e.id
        });
      }
    });
    this.persistableStateService = persistableStateService;
    this.inject = (0, _common.createInject)(this.persistableStateService);
    this.extract = (0, _common.createExtract)(this.persistableStateService);
  }
  getDefaultInput() {
    return _dashboard_constants.DEFAULT_DASHBOARD_INPUT;
  }
}
exports.DashboardContainerFactoryDefinition = DashboardContainerFactoryDefinition;