"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showSettings = showSettings;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _plugin_services = require("../../../services/plugin_services");
var _settings_flyout = require("../../component/settings/settings_flyout");
var _dashboard_container = require("../dashboard_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function showSettings() {
  const {
    settings: {
      theme: {
        theme$
      }
    },
    overlays
  } = _plugin_services.pluginServices.getServices();

  // TODO Move this action into DashboardContainer.openOverlay
  this.dispatch.setHasOverlays(true);
  this.openOverlay(overlays.openFlyout((0, _public.toMountPoint)( /*#__PURE__*/_react.default.createElement(_dashboard_container.DashboardContainerContext.Provider, {
    value: this
  }, /*#__PURE__*/_react.default.createElement(_settings_flyout.DashboardSettings, {
    onClose: () => {
      this.dispatch.setHasOverlays(false);
      this.clearOverlays();
    }
  })), {
    theme$
  }), {
    size: 's',
    'data-test-subj': 'dashboardSettingsFlyout',
    onClose: flyout => {
      this.clearOverlays();
      this.dispatch.setHasOverlays(false);
      flyout.close();
    }
  }));
}