"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddTimeSliderControlButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/controls-plugin/public");
var _dashboard_app_strings = require("../../_dashboard_app_strings");
var _dashboard_app = require("../../dashboard_app");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const AddTimeSliderControlButton = ({
  closePopover,
  controlGroup,
  ...rest
}) => {
  const [hasTimeSliderControl, setHasTimeSliderControl] = (0, _react.useState)(false);
  const dashboard = (0, _dashboard_app.useDashboardAPI)();
  (0, _react.useEffect)(() => {
    const subscription = controlGroup.getInput$().subscribe(() => {
      const childIds = controlGroup.getChildIds();
      const nextHasTimeSliderControl = childIds.some(id => {
        const child = controlGroup.getChild(id);
        return child.type === _public.TIME_SLIDER_CONTROL;
      });
      if (nextHasTimeSliderControl !== hasTimeSliderControl) {
        setHasTimeSliderControl(nextHasTimeSliderControl);
      }
    });
    return () => {
      subscription.unsubscribe();
    };
  }, [controlGroup, hasTimeSliderControl, setHasTimeSliderControl]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, (0, _extends2.default)({}, rest, {
    icon: "timeslider",
    onClick: async () => {
      await controlGroup.addTimeSliderControl();
      dashboard.scrollToTop();
      closePopover();
    },
    "data-test-subj": "controls-create-timeslider-button",
    disabled: hasTimeSliderControl,
    toolTipContent: hasTimeSliderControl ? (0, _dashboard_app_strings.getOnlyOneTimeSliderControlMsg)() : null
  }), (0, _dashboard_app_strings.getAddTimeSliderControlButtonTitle)());
};
exports.AddTimeSliderControlButton = AddTimeSliderControlButton;