"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExportCSVAction = exports.ACTION_EXPORT_CSV = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/share-plugin/public");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _plugin_services = require("../services/plugin_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ACTION_EXPORT_CSV = 'ACTION_EXPORT_CSV';
exports.ACTION_EXPORT_CSV = ACTION_EXPORT_CSV;
/**
 * This is "Export CSV" action which appears in the context
 * menu of a dashboard panel.
 */
class ExportCSVAction {
  constructor() {
    (0, _defineProperty2.default)(this, "id", ACTION_EXPORT_CSV);
    (0, _defineProperty2.default)(this, "type", ACTION_EXPORT_CSV);
    (0, _defineProperty2.default)(this, "order", 5);
    (0, _defineProperty2.default)(this, "fieldFormats", void 0);
    (0, _defineProperty2.default)(this, "uiSettings", void 0);
    (0, _defineProperty2.default)(this, "getDisplayName", context => _dashboard_actions_strings.dashboardExportCsvActionStrings.getDisplayName());
    (0, _defineProperty2.default)(this, "hasDatatableContent", adapters => {
      return Object.keys((adapters === null || adapters === void 0 ? void 0 : adapters.tables) || {}).length > 0 && adapters.tables.allowCsvExport;
    });
    (0, _defineProperty2.default)(this, "getFormatter", () => {
      if (this.fieldFormats) {
        return this.fieldFormats.deserialize;
      }
    });
    (0, _defineProperty2.default)(this, "getDataTableContent", adapters => {
      if (this.hasDatatableContent(adapters)) {
        return adapters === null || adapters === void 0 ? void 0 : adapters.tables.tables;
      }
      return;
    });
    (0, _defineProperty2.default)(this, "exportCSV", async context => {
      var _context$embeddable;
      const formatFactory = this.getFormatter();
      // early exit if not formatter is available
      if (!formatFactory) {
        return;
      }
      const tableAdapters = this.getDataTableContent(context === null || context === void 0 ? void 0 : (_context$embeddable = context.embeddable) === null || _context$embeddable === void 0 ? void 0 : _context$embeddable.getInspectorAdapters());
      if (tableAdapters) {
        const datatables = Object.values(tableAdapters);
        const content = datatables.reduce((memo, datatable, i) => {
          // skip empty datatables
          if (datatable) {
            const postFix = datatables.length > 1 ? `-${i + 1}` : '';
            const untitledFilename = _dashboard_actions_strings.dashboardExportCsvActionStrings.getUntitledFilename();
            memo[`${context.embeddable.getTitle() || untitledFilename}${postFix}.csv`] = {
              content: _public.exporters.datatableToCSV(datatable, {
                csvSeparator: this.uiSettings.get('csv:separator', ','),
                quoteValues: this.uiSettings.get('csv:quoteValues', true),
                formatFactory,
                escapeFormulaValues: false
              }),
              type: _public.exporters.CSV_MIME_TYPE
            };
          }
          return memo;
        }, {});

        // useful for testing
        if (context.asString) {
          return content;
        }
        if (content) {
          return (0, _public2.downloadMultipleAs)(content);
        }
      }
    });
    ({
      data: {
        fieldFormats: this.fieldFormats
      },
      settings: {
        uiSettings: this.uiSettings
      }
    } = _plugin_services.pluginServices.getServices());
  }
  getIconType() {
    return 'exportAction';
  }
  async isCompatible(context) {
    var _context$embeddable2, _context$embeddable2$;
    return !!this.hasDatatableContent((_context$embeddable2 = context.embeddable) === null || _context$embeddable2 === void 0 ? void 0 : (_context$embeddable2$ = _context$embeddable2.getInspectorAdapters) === null || _context$embeddable2$ === void 0 ? void 0 : _context$embeddable2$.call(_context$embeddable2));
  }
  async execute(context) {
    // make it testable: type here will be forced
    return await this.exportCSV(context);
  }
}
exports.ExportCSVAction = ExportCSVAction;