"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MenuItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-utils-plugin/public");
var _i18n = require("./i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MenuItem = ({
  context
}) => {
  const {
    events
  } = (0, _public.useContainerState)(context.embeddable.enhancements.dynamicActions.state);
  const count = events.length;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: 'center'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, _i18n.txtDisplayName), count > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, null, count)));
};
exports.MenuItem = MenuItem;