"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../../constants");
var _components = require("../../../../../components");
var _routing = require("../../../../../services/routing");
var _track_ui_metric = require("../../../../../services/track_ui_metric");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const actionI18nTexts = {
  pause: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternList.table.actionPauseDescription', {
    defaultMessage: 'Pause replication'
  }),
  resume: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternList.table.actionResumeDescription', {
    defaultMessage: 'Resume replication'
  }),
  edit: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternList.table.actionEditDescription', {
    defaultMessage: 'Edit auto-follow pattern'
  }),
  delete: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternList.table.actionDeleteDescription', {
    defaultMessage: 'Delete auto-follow pattern'
  })
};
const getFilteredPatterns = (autoFollowPatterns, queryText) => {
  if (queryText) {
    const normalizedSearchText = queryText.toLowerCase();
    return autoFollowPatterns.filter(autoFollowPattern => {
      // default values to avoid undefined errors
      const {
        name = '',
        remoteCluster = '',
        followIndexPatternPrefix = '',
        followIndexPatternSuffix = ''
      } = autoFollowPattern;
      const inName = name.toLowerCase().includes(normalizedSearchText);
      const inRemoteCluster = remoteCluster.toLowerCase().includes(normalizedSearchText);
      const inPrefix = followIndexPatternPrefix.toLowerCase().includes(normalizedSearchText);
      const inSuffix = followIndexPatternSuffix.toLowerCase().includes(normalizedSearchText);
      return inName || inRemoteCluster || inPrefix || inSuffix;
    });
  }
  return autoFollowPatterns;
};
class AutoFollowPatternTable extends _react.PureComponent {
  static getDerivedStateFromProps(props, state) {
    const {
      autoFollowPatterns
    } = props;
    const {
      prevAutoFollowPatterns,
      queryText
    } = state;

    // If an auto-follow pattern gets deleted, we need to recreate the cached filtered auto-follow patterns.
    if (prevAutoFollowPatterns !== autoFollowPatterns) {
      return {
        prevAutoFollowPatterns: autoFollowPatterns,
        filteredAutoFollowPatterns: getFilteredPatterns(autoFollowPatterns, queryText)
      };
    }
    return null;
  }
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onSearch", ({
      query
    }) => {
      const {
        autoFollowPatterns
      } = this.props;
      const {
        text
      } = query;

      // We cache the filtered indices instead of calculating them inside render() because
      // of https://github.com/elastic/eui/issues/3445.
      this.setState({
        queryText: text,
        filteredAutoFollowPatterns: getFilteredPatterns(autoFollowPatterns, text)
      });
    });
    (0, _defineProperty2.default)(this, "renderLoading", () => {
      const {
        apiStatusDelete
      } = this.props;
      if (apiStatusDelete === _constants.API_STATUS.DELETING) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
          logo: "logoKibana",
          size: "xl"
        }));
      }
      return null;
    });
    this.state = {
      prevAutoFollowPatterns: props.autoFollowPatterns,
      selectedItems: [],
      filteredAutoFollowPatterns: props.autoFollowPatterns,
      queryText: ''
    };
  }
  getTableColumns(deleteAutoFollowPattern) {
    const {
      selectAutoFollowPattern
    } = this.props;
    return [{
      field: 'name',
      name: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternList.table.nameColumnTitle', {
        defaultMessage: 'Name'
      }),
      sortable: true,
      truncateText: false,
      render: name => {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: () => {
            (0, _track_ui_metric.trackUiMetric)('click', _constants.UIM_AUTO_FOLLOW_PATTERN_SHOW_DETAILS_CLICK);
            selectAutoFollowPattern(name);
          },
          "data-test-subj": "autoFollowPatternLink"
        }, name);
      }
    }, {
      field: 'active',
      dataType: 'boolean',
      name: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternList.table.statusTitle', {
        defaultMessage: 'Status'
      }),
      render: active => {
        const statusText = active ? _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternList.table.statusTextActive', {
          defaultMessage: 'Active'
        }) : _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternList.table.statusTextPaused', {
          defaultMessage: 'Paused'
        });
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
          color: active ? 'success' : 'subdued'
        }), "\xA0", statusText);
      },
      sortable: true
    }, {
      field: 'remoteCluster',
      name: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternList.table.clusterColumnTitle', {
        defaultMessage: 'Remote cluster'
      }),
      truncateText: true,
      sortable: true
    }, {
      field: 'leaderIndexPatterns',
      name: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternList.table.leaderPatternsColumnTitle', {
        defaultMessage: 'Leader patterns'
      }),
      render: leaderIndexPatterns => leaderIndexPatterns.join(', ')
    }, {
      field: 'followIndexPatternPrefix',
      name: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternList.table.prefixColumnTitle', {
        defaultMessage: 'Follower index prefix'
      }),
      sortable: true
    }, {
      field: 'followIndexPatternSuffix',
      name: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternList.table.suffixColumnTitle', {
        defaultMessage: 'Follower index suffix'
      }),
      sortable: true
    }, {
      name: _i18n.i18n.translate('xpack.crossClusterReplication.autoFollowPatternList.table.actionsColumnTitle', {
        defaultMessage: 'Actions'
      }),
      actions: [{
        name: actionI18nTexts.pause,
        description: actionI18nTexts.pause,
        icon: 'pause',
        onClick: item => this.props.pauseAutoFollowPattern(item.name),
        available: item => item.active,
        'data-test-subj': 'contextMenuPauseButton'
      }, {
        name: actionI18nTexts.resume,
        description: actionI18nTexts.resume,
        icon: 'play',
        onClick: item => this.props.resumeAutoFollowPattern(item.name),
        available: item => !item.active,
        'data-test-subj': 'contextMenuResumeButton'
      }, {
        name: actionI18nTexts.edit,
        description: actionI18nTexts.edit,
        icon: 'pencil',
        onClick: item => _routing.routing.navigate(_routing.routing.getAutoFollowPatternPath(item.name)),
        'data-test-subj': 'contextMenuEditButton'
      }, {
        name: actionI18nTexts.delete,
        description: actionI18nTexts.delete,
        icon: 'trash',
        onClick: item => deleteAutoFollowPattern(item.name),
        'data-test-subj': 'contextMenuDeleteButton'
      }],
      width: '100px'
    }];
  }
  render() {
    const {
      selectedItems,
      filteredAutoFollowPatterns
    } = this.state;
    const sorting = {
      sort: {
        field: 'name',
        direction: 'asc'
      }
    };
    const pagination = {
      initialPageSize: 20,
      pageSizeOptions: [10, 20, 50]
    };
    const selection = {
      onSelectionChange: selectedItems => this.setState({
        selectedItems: selectedItems.map(({
          name
        }) => name)
      })
    };
    const search = {
      toolsLeft: selectedItems.length ? /*#__PURE__*/_react.default.createElement(_components.AutoFollowPatternActionMenu, {
        arrowDirection: "down",
        patterns: this.state.selectedItems.map(name => filteredAutoFollowPatterns.find(item => item.name === name))
      }) : undefined,
      toolsRight: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(_routing.routing._reactRouter.history, `/auto_follow_patterns/add`), {
        fill: true,
        iconType: "plusInCircle",
        "data-test-subj": "createAutoFollowPatternButton"
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.autoFollowPatternList.addAutoFollowPatternButtonLabel",
        defaultMessage: "Create an auto-follow pattern"
      })),
      onChange: this.onSearch,
      box: {
        incremental: true,
        'data-test-subj': 'autoFollowPatternSearch'
      }
    };
    return /*#__PURE__*/_react.default.createElement(_components.AutoFollowPatternDeleteProvider, null, deleteAutoFollowPattern => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      items: filteredAutoFollowPatterns,
      itemId: "name",
      columns: this.getTableColumns(deleteAutoFollowPattern),
      search: search,
      pagination: pagination,
      sorting: sorting,
      selection: selection,
      isSelectable: true,
      rowProps: () => ({
        'data-test-subj': 'row'
      }),
      cellProps: (item, column) => ({
        'data-test-subj': `cell_${column.field}`
      }),
      "data-test-subj": "autoFollowPatternListTable"
    }), this.renderLoading()));
  }
}
exports.AutoFollowPatternTable = AutoFollowPatternTable;
(0, _defineProperty2.default)(AutoFollowPatternTable, "propTypes", {
  autoFollowPatterns: _propTypes.default.array,
  selectAutoFollowPattern: _propTypes.default.func.isRequired,
  pauseAutoFollowPattern: _propTypes.default.func.isRequired,
  resumeAutoFollowPattern: _propTypes.default.func.isRequired
});