"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logOverallStatusChanges = void 0;
var _operators = require("rxjs/operators");
var _coreStatusCommon = require("@kbn/core-status-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const logOverallStatusChanges = ({
  logger,
  overall$,
  stop$
}) => {
  return overall$.pipe((0, _operators.takeUntil)(stop$), (0, _operators.distinctUntilChanged)((previous, next) => {
    return previous.level.toString() === next.level.toString();
  }), (0, _operators.startWith)(undefined), (0, _operators.pairwise)(), (0, _operators.map)(([oldStatus, newStatus]) => {
    const oldStatusMessage = oldStatus ? ` (was ${oldStatus.level.toString()})` : '';
    const reason = (newStatus === null || newStatus === void 0 ? void 0 : newStatus.level) !== _coreStatusCommon.ServiceStatusLevels.available && newStatus !== null && newStatus !== void 0 && newStatus.summary ? `: ${newStatus === null || newStatus === void 0 ? void 0 : newStatus.summary}` : '';
    return {
      message: `Kibana is now ${newStatus.level.toString()}${oldStatusMessage}${reason}`,
      level: newStatus === null || newStatus === void 0 ? void 0 : newStatus.level
    };
  })).subscribe(({
    message,
    level
  }) => {
    switch (level) {
      case _coreStatusCommon.ServiceStatusLevels.available:
        logger.info(message);
        break;
      case _coreStatusCommon.ServiceStatusLevels.degraded:
        logger.warn(message);
        break;
      default:
        logger.error(message);
    }
  });
};
exports.logOverallStatusChanges = logOverallStatusChanges;