"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerBulkDeleteRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const registerBulkDeleteRoute = (router, {
  config,
  coreUsageData,
  logger
}) => {
  const {
    allowHttpApiAccess
  } = config;
  router.post({
    path: '/_bulk_delete',
    validate: {
      body: _configSchema.schema.arrayOf(_configSchema.schema.object({
        type: _configSchema.schema.string(),
        id: _configSchema.schema.string()
      })),
      query: _configSchema.schema.object({
        force: _configSchema.schema.maybe(_configSchema.schema.boolean())
      })
    }
  }, (0, _utils.catchAndReturnBoomErrors)(async (context, req, res) => {
    (0, _utils.logWarnOnExternalRequest)({
      method: 'post',
      path: '/api/saved_objects/_bulk_delete',
      req,
      logger
    });
    const {
      force
    } = req.query;
    const usageStatsClient = coreUsageData.getClient();
    usageStatsClient.incrementSavedObjectsBulkDelete({
      request: req
    }).catch(() => {});
    const {
      savedObjects
    } = await context.core;
    const typesToCheck = [...new Set(req.body.map(({
      type
    }) => type))];
    if (!allowHttpApiAccess) {
      (0, _utils.throwIfAnyTypeNotVisibleByAPI)(typesToCheck, savedObjects.typeRegistry);
    }
    const statuses = await savedObjects.client.bulkDelete(req.body, {
      force
    });
    return res.ok({
      body: statuses
    });
  }));
};
exports.registerBulkDeleteRoute = registerBulkDeleteRoute;