"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkVersionCompatibility = void 0;
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const checkVersionCompatibility = ({
  mappings,
  types,
  source,
  deletedTypes
}) => {
  const appVersions = (0, _coreSavedObjectsBaseServerInternal.getVirtualVersionMap)(types);
  const indexVersions = (0, _coreSavedObjectsBaseServerInternal.getVirtualVersionsFromMappings)({
    mappings,
    source,
    knownTypes: types.map(type => type.name)
  });
  if (!indexVersions) {
    throw new Error(`Cannot check version: ${source} not present in the mapping meta`);
  }
  return (0, _coreSavedObjectsBaseServerInternal.compareVirtualVersions)({
    appVersions,
    indexVersions,
    deletedTypes
  });
};
exports.checkVersionCompatibility = checkVersionCompatibility;