"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateIndexMappingsWaitForTask = void 0;
require("lodash");
var Either = _interopRequireWildcard(require("fp-ts/lib/Either"));
var _retry_state = require("../../../model/retry_state");
var _helpers = require("../../../model/helpers");
var _actions = require("../../actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const updateIndexMappingsWaitForTask = (state, res, context) => {
  if (Either.isLeft(res)) {
    const left = res.left;
    if ((0, _actions.isTypeof)(left, 'wait_for_task_completion_timeout')) {
      // After waiting for the specified timeout, the task has not yet
      // completed. Retry this step to see if the task has completed after an
      // exponential delay.  We will basically keep polling forever until the
      // Elasticsearch task succeeds or fails.
      return (0, _retry_state.delayRetryState)(state, left.message, Number.MAX_SAFE_INTEGER);
    } else {
      (0, _helpers.throwBadResponse)(state, left);
    }
  }
  return {
    ...state,
    controlState: 'UPDATE_MAPPING_MODEL_VERSIONS'
  };
};
exports.updateIndexMappingsWaitForTask = updateIndexMappingsWaitForTask;