"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getModelVersionTransforms = exports.getModelVersionSchemas = exports.convertModelVersionTransformFn = void 0;
var _coreSavedObjectsBaseServerInternal = require("@kbn/core-saved-objects-base-server-internal");
var _core = require("../core");
var _types = require("./types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const getModelVersionSchemas = ({
  typeDefinition
}) => {
  var _typeDefinition$model;
  const modelVersionMap = typeof typeDefinition.modelVersions === 'function' ? typeDefinition.modelVersions() : (_typeDefinition$model = typeDefinition.modelVersions) !== null && _typeDefinition$model !== void 0 ? _typeDefinition$model : {};
  return Object.entries(modelVersionMap).reduce((map, [rawModelVersion, versionDefinition]) => {
    var _versionDefinition$sc;
    const schema = (_versionDefinition$sc = versionDefinition.schemas) === null || _versionDefinition$sc === void 0 ? void 0 : _versionDefinition$sc.forwardCompatibility;
    if (schema) {
      const modelVersion = (0, _coreSavedObjectsBaseServerInternal.assertValidModelVersion)(rawModelVersion);
      const virtualVersion = (0, _coreSavedObjectsBaseServerInternal.modelVersionToVirtualVersion)(modelVersion);
      map[virtualVersion] = (0, _coreSavedObjectsBaseServerInternal.convertModelVersionBackwardConversionSchema)(schema);
    }
    return map;
  }, {});
};
exports.getModelVersionSchemas = getModelVersionSchemas;
const getModelVersionTransforms = ({
  typeDefinition,
  log
}) => {
  var _typeDefinition$model2;
  const modelVersionMap = typeof typeDefinition.modelVersions === 'function' ? typeDefinition.modelVersions() : (_typeDefinition$model2 = typeDefinition.modelVersions) !== null && _typeDefinition$model2 !== void 0 ? _typeDefinition$model2 : {};
  return Object.entries(modelVersionMap).map(([rawModelVersion, definition]) => {
    const modelVersion = (0, _coreSavedObjectsBaseServerInternal.assertValidModelVersion)(rawModelVersion);
    const virtualVersion = (0, _coreSavedObjectsBaseServerInternal.modelVersionToVirtualVersion)(modelVersion);
    return {
      version: virtualVersion,
      transform: convertModelVersionTransformFn({
        typeDefinition,
        log,
        modelVersion,
        virtualVersion,
        modelVersionDefinition: definition
      }),
      transformType: _types.TransformType.Migrate
    };
  });
};
exports.getModelVersionTransforms = getModelVersionTransforms;
const convertModelVersionTransformFn = ({
  typeDefinition,
  virtualVersion,
  modelVersion,
  modelVersionDefinition,
  log
}) => {
  const context = {
    log,
    modelVersion,
    namespaceType: typeDefinition.namespaceType
  };
  const modelTransformFn = (0, _coreSavedObjectsBaseServerInternal.buildModelVersionTransformFn)(modelVersionDefinition.changes);
  return function convertedTransform(doc) {
    try {
      const result = modelTransformFn(doc, context);
      return {
        transformedDoc: result.document,
        additionalDocs: []
      };
    } catch (error) {
      log.error(error);
      throw new _core.TransformSavedObjectDocumentError(error, virtualVersion);
    }
  };
};
exports.convertModelVersionTransformFn = convertModelVersionTransformFn;