"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildPickupMappingsQuery = void 0;
var _build_active_mappings = require("./build_active_mappings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const buildPickupMappingsQuery = updatedFields => {
  const rootFields = Object.keys((0, _build_active_mappings.getBaseMappings)().properties);
  if (updatedFields.some(field => rootFields.includes(field))) {
    // we are updating some root fields, update ALL documents (no filter query)
    return undefined;
  }

  // at this point, all updated fields correspond to SO types
  const updatedTypes = updatedFields;
  return {
    bool: {
      should: updatedTypes.map(type => ({
        term: {
          type
        }
      }))
    }
  };
};
exports.buildPickupMappingsQuery = buildPickupMappingsQuery;