"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.moveFile = void 0;
var _promises = require("fs/promises");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const moveFile = async (oldPath, newPath) => {
  try {
    await (0, _promises.rename)(oldPath, newPath);
  } catch (err) {
    // rename isn't supported on some file systems / volumes
    // so we fallback to copy+delete
    if (err.code === 'EXDEV') {
      await (0, _promises.copyFile)(oldPath, newPath);
      await (0, _promises.unlink)(oldPath);
    } else {
      throw err;
    }
  }
};
exports.moveFile = moveFile;