"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasQueryVersion = hasQueryVersion;
exports.isAllowedPublicVersion = isAllowedPublicVersion;
exports.isValidRouteVersion = isValidRouteVersion;
exports.readVersion = readVersion;
exports.removeQueryVersion = removeQueryVersion;
var _coreHttpCommon = require("@kbn/core-http-common");
var _lodash = require("lodash");
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const PUBLIC_VERSION_REGEX = /^[0-9]{4}-[0-9]{2}-[0-9]{2}$/;
const INTERNAL_VERSION_REGEX = /^[1-9][0-9]*$/;

/**
 * To bring all of Kibana's first public API versions in-sync with an initial
 * release date we only allow one public version temporarily.
 * @internal
 */
const ALLOWED_PUBLIC_VERSION = '2023-10-31';
function isAllowedPublicVersion(version) {
  if (ALLOWED_PUBLIC_VERSION !== version) {
    return `Invalid public version, for now please use "${ALLOWED_PUBLIC_VERSION}" as the version for all public routes. Received "${version}".}"`;
  }
}

/**
 * For public routes we must check that the version is a string that is YYYY-MM-DD.
 * For internal routes we must check that the version is a number.
 * @internal
 */
function isValidRouteVersion(isPublicApi, version) {
  if (isPublicApi) {
    return PUBLIC_VERSION_REGEX.test(version) && (0, _moment.default)(version, 'YYYY-MM-DD').isValid() ? undefined : `Invalid version. Received "${version}", expected a valid date string formatted as YYYY-MM-DD.`;
  }
  return INTERNAL_VERSION_REGEX.test(version) && version !== '0' ? undefined : `Invalid version number. Received "${version}", expected a string containing _only_ a finite, whole number greater than 0.`;
}
function hasQueryVersion(request) {
  return (0, _lodash.isObject)(request.query) && _coreHttpCommon.ELASTIC_HTTP_VERSION_QUERY_PARAM in request.query;
}
function removeQueryVersion(request) {
  delete request.query[_coreHttpCommon.ELASTIC_HTTP_VERSION_QUERY_PARAM];
}
function readQueryVersion(request) {
  const version = (0, _lodash.get)(request.query, _coreHttpCommon.ELASTIC_HTTP_VERSION_QUERY_PARAM);
  if (typeof version === 'string') return version;
}
/** Reading from header takes precedence over query param */
function readVersion(request, isQueryVersionEnabled) {
  var _request$headers;
  const versions = (_request$headers = request.headers) === null || _request$headers === void 0 ? void 0 : _request$headers[_coreHttpCommon.ELASTIC_HTTP_VERSION_HEADER];
  const headerVersion = Array.isArray(versions) ? versions[0] : versions;
  if (headerVersion) return headerVersion;
  if (isQueryVersionEnabled) return readQueryVersion(request);
}