"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolvers = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Assumes that there is at least one version in the array.
 * @internal
 */

const oldest = versions => [...versions].sort((a, b) => a.localeCompare(b))[0];
const newest = versions => [...versions].sort((a, b) => b.localeCompare(a))[0];
const none = () => undefined;
const resolvers = {
  oldest,
  newest,
  none
};
exports.resolvers = resolvers;