"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configSchema = exports.config = exports.CoreAppPath = exports.CoreAppConfig = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 * Validation schema for Core App config.
 * @public
 */
const configSchema = _configSchema.schema.object({
  allowDynamicConfigOverrides: _configSchema.schema.boolean({
    defaultValue: false
  })
});
exports.configSchema = configSchema;
const CoreAppPath = 'coreApp';
exports.CoreAppPath = CoreAppPath;
const config = {
  path: CoreAppPath,
  schema: configSchema
};

/**
 * Wrapper of config schema.
 * @internal
 */
exports.config = config;
class CoreAppConfig {
  /**
   * @internal
   * When true, the HTTP API to dynamically extend the configuration is registered.
   *
   * @remarks
   * You should enable this at your own risk: Settings opted-in to being dynamically
   * configurable can be changed at any given point, potentially leading to unexpected behaviours.
   * This feature is mostly intended for testing purposes.
   */

  constructor(rawConfig) {
    (0, _defineProperty2.default)(this, "allowDynamicConfigOverrides", void 0);
    this.allowDynamicConfigOverrides = rawConfig.allowDynamicConfigOverrides;
  }
}
exports.CoreAppConfig = CoreAppConfig;