"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.controlsServiceFactory = exports.controlsService = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const controlsServiceFactory = () => controlsService;
exports.controlsServiceFactory = controlsServiceFactory;
const controlsFactoriesMap = {};

// export controls service directly for use in plugin setup lifecycle
const controlsService = {
  registerControlType: factory => {
    controlsFactoriesMap[factory.type] = factory;
  },
  getControlFactory: type => {
    return controlsFactoriesMap[type];
  },
  getControlTypes: () => Object.keys(controlsFactoriesMap)
};
exports.controlsService = controlsService;