"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.update = void 0;
var _schemas = require("../../../common/schemas");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const update = {
  schemas: _schemas.rpcSchemas.update,
  fn: async (ctx, {
    contentTypeId,
    id,
    version,
    data,
    options
  }) => {
    const storageContext = (0, _utils.getStorageContext)({
      contentTypeId,
      version,
      ctx
    });
    const crudInstance = ctx.contentRegistry.getCrud(contentTypeId);
    return crudInstance.update(storageContext, id, data, options);
  }
};
exports.update = update;