"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WalkingState = WalkingState;
exports.populateContext = populateContext;
exports.walkTokenPath = walkTokenPath;
exports.wrapComponentWithDefaults = wrapComponentWithDefaults;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function wrapComponentWithDefaults(component, defaults) {
  const originalGetTerms = component.getTerms;
  component.getTerms = function (context, editor) {
    let result = originalGetTerms.call(component, context, editor);
    if (!result) {
      return result;
    }
    result = _lodash.default.map(result, term => {
      if (!_lodash.default.isObject(term)) {
        term = {
          name: term
        };
      }
      return _lodash.default.defaults(term, defaults);
    });
    return result;
  };
  return component;
}
const tracer = function () {
  if (window.engine_trace) {
    console.log.call(console, ...arguments);
  }
};
function passThroughContext(context, extensionList) {
  function PTC() {}
  PTC.prototype = context;
  const result = new PTC();
  if (extensionList) {
    extensionList.unshift(result);
    _lodash.default.assign.apply(_lodash.default, extensionList);
    extensionList.shift();
  }
  return result;
}
function WalkingState(parentName, components, contextExtensionList, depth, priority) {
  this.parentName = parentName;
  this.components = components;
  this.contextExtensionList = contextExtensionList;
  this.depth = depth || 0;
  this.priority = priority;
}
function walkTokenPath(tokenPath, walkingStates, context, editor) {
  if (!tokenPath || tokenPath.length === 0) {
    return walkingStates;
  }
  const token = tokenPath[0];
  const nextWalkingStates = [];
  tracer('starting token evaluation [' + token + ']');
  _lodash.default.each(walkingStates, function (ws) {
    const contextForState = passThroughContext(context, ws.contextExtensionList);
    _lodash.default.each(ws.components, function (component) {
      tracer('evaluating [' + token + '] with [' + component.name + ']', component);
      const result = component.match(token, contextForState, editor);
      if (result && !_lodash.default.isEmpty(result)) {
        tracer('matched [' + token + '] with:', result);
        let next;
        let extensionList;
        if (result.next && !Array.isArray(result.next)) {
          next = [result.next];
        } else {
          next = result.next;
        }
        if (result.context_values) {
          extensionList = [];
          [].push.apply(extensionList, ws.contextExtensionList);
          extensionList.push(result.context_values);
        } else {
          extensionList = ws.contextExtensionList;
        }
        let priority = ws.priority;
        if (_lodash.default.isNumber(result.priority)) {
          if (_lodash.default.isNumber(priority)) {
            priority = Math.min(priority, result.priority);
          } else {
            priority = result.priority;
          }
        }
        nextWalkingStates.push(new WalkingState(component.name, next, extensionList, ws.depth + 1, priority));
      }
    });
  });
  if (nextWalkingStates.length === 0) {
    // no where to go, still return context variables returned so far..
    return _lodash.default.map(walkingStates, function (ws) {
      return new WalkingState(ws.name, [], ws.contextExtensionList);
    });
  }
  return walkTokenPath(tokenPath.slice(1), nextWalkingStates, context, editor);
}
function populateContext(tokenPath, context, editor, includeAutoComplete, components) {
  let walkStates = walkTokenPath(tokenPath, [new WalkingState('ROOT', components, [])], context, editor);
  if (includeAutoComplete) {
    let autoCompleteSet = [];
    _lodash.default.each(walkStates, function (ws) {
      const contextForState = passThroughContext(context, ws.contextExtensionList);
      _lodash.default.each(ws.components, function (component) {
        _lodash.default.each(component.getTerms(contextForState, editor), function (term) {
          if (!_lodash.default.isObject(term)) {
            term = {
              name: term
            };
          }
          autoCompleteSet.push(term);
        });
      });
    });
    autoCompleteSet = _lodash.default.uniq(autoCompleteSet);
    context.autoCompleteSet = autoCompleteSet;
  }

  // apply what values were set so far to context, selecting the deepest on which sets the context
  if (walkStates.length !== 0) {
    let wsToUse;
    walkStates = _lodash.default.sortBy(walkStates, function (ws) {
      return _lodash.default.isNumber(ws.priority) ? ws.priority : Number.MAX_VALUE;
    });
    wsToUse = _lodash.default.find(walkStates, function (ws) {
      return _lodash.default.isEmpty(ws.components);
    });
    if (!wsToUse && walkStates.length > 1 && !includeAutoComplete) {
      console.info("more than one context active for current path, but autocomplete isn't requested", walkStates);
    }
    if (!wsToUse) {
      wsToUse = walkStates[0];
    }
    _lodash.default.each(wsToUse.contextExtensionList, function (extension) {
      _lodash.default.assign(context, extension);
    });
  }
}