"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopNavConfig = getTopNavConfig;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getTopNavConfig({
  onClickHistory,
  onClickSettings,
  onClickHelp,
  onClickVariables
}) {
  return [{
    id: 'history',
    label: _i18n.i18n.translate('console.topNav.historyTabLabel', {
      defaultMessage: 'History'
    }),
    description: _i18n.i18n.translate('console.topNav.historyTabDescription', {
      defaultMessage: 'History'
    }),
    onClick: () => {
      onClickHistory();
    },
    testId: 'consoleHistoryButton'
  }, {
    id: 'settings',
    label: _i18n.i18n.translate('console.topNav.settingsTabLabel', {
      defaultMessage: 'Settings'
    }),
    description: _i18n.i18n.translate('console.topNav.settingsTabDescription', {
      defaultMessage: 'Settings'
    }),
    onClick: () => {
      onClickSettings();
    },
    testId: 'consoleSettingsButton'
  }, {
    id: 'variables',
    label: _i18n.i18n.translate('console.topNav.variablesTabLabel', {
      defaultMessage: 'Variables'
    }),
    description: _i18n.i18n.translate('console.topNav.variablesTabDescription', {
      defaultMessage: 'Variables'
    }),
    onClick: () => {
      onClickVariables();
    },
    testId: 'consoleVariablesButton'
  }, {
    id: 'help',
    label: _i18n.i18n.translate('console.topNav.helpTabLabel', {
      defaultMessage: 'Help'
    }),
    description: _i18n.i18n.translate('console.topNav.helpTabDescription', {
      defaultMessage: 'Help'
    }),
    onClick: () => {
      onClickHelp();
    },
    testId: 'consoleHelpButton'
  }];
}