"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DEFAULT_NEUTRAL_PALETTE_INDEX = exports.DEFAULT_COLOR_MAPPING_CONFIG = void 0;
exports.getColorsFromMapping = getColorsFromMapping;
exports.getPaletteColors = getPaletteColors;
var _palettes = require("../palettes");
var _eui_amsterdam = require("../palettes/eui_amsterdam");
var _neutral = require("../palettes/neutral");
var _color_handling = require("../color/color_handling");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const DEFAULT_NEUTRAL_PALETTE_INDEX = 1;

/**
 * The default color mapping used in Kibana, starts with the EUI color palette
 */
exports.DEFAULT_NEUTRAL_PALETTE_INDEX = DEFAULT_NEUTRAL_PALETTE_INDEX;
const DEFAULT_COLOR_MAPPING_CONFIG = {
  assignmentMode: 'auto',
  assignments: [],
  specialAssignments: [{
    rule: {
      type: 'other'
    },
    color: {
      type: 'categorical',
      paletteId: _neutral.NeutralPalette.id,
      colorIndex: DEFAULT_NEUTRAL_PALETTE_INDEX
    },
    touched: false
  }],
  paletteId: _eui_amsterdam.EUIAmsterdamColorBlindPalette.id,
  colorMode: {
    type: 'categorical'
  }
};
exports.DEFAULT_COLOR_MAPPING_CONFIG = DEFAULT_COLOR_MAPPING_CONFIG;
function getPaletteColors(isDarkMode, colorMappings) {
  const colorMappingModel = colorMappings !== null && colorMappings !== void 0 ? colorMappings : {
    ...DEFAULT_COLOR_MAPPING_CONFIG
  };
  const palette = (0, _palettes.getPalette)(_palettes.AVAILABLE_PALETTES, _neutral.NeutralPalette)(colorMappingModel.paletteId);
  return Array.from({
    length: palette.colorCount
  }, (d, i) => palette.getColor(i, isDarkMode));
}
function getColorsFromMapping(isDarkMode, colorMappings) {
  const {
    colorMode,
    paletteId,
    assignmentMode,
    assignments,
    specialAssignments
  } = colorMappings !== null && colorMappings !== void 0 ? colorMappings : {
    ...DEFAULT_COLOR_MAPPING_CONFIG
  };
  const getPaletteFn = (0, _palettes.getPalette)(_palettes.AVAILABLE_PALETTES, _neutral.NeutralPalette);
  if (colorMode.type === 'gradient') {
    const colorScale = (0, _color_handling.getGradientColorScale)(colorMode, getPaletteFn, isDarkMode);
    return Array.from({
      length: 6
    }, (d, i) => colorScale(i / 6));
  } else {
    const palette = getPaletteFn(paletteId);
    if (assignmentMode === 'auto') {
      return Array.from({
        length: palette.colorCount
      }, (d, i) => palette.getColor(i, isDarkMode));
    } else {
      return [...assignments.map(a => {
        return a.color.type === 'gradient' ? '' : (0, _color_handling.getColor)(a.color, getPaletteFn, isDarkMode);
      }), ...specialAssignments.map(a => {
        return (0, _color_handling.getColor)(a.color, getPaletteFn, isDarkMode);
      })].filter(color => color !== '');
    }
  }
}