"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColorPicker = ColorPicker;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _palette_colors = require("./palette_colors");
var _rgb_picker = require("./rgb_picker");
var _neutral = require("../../palettes/neutral");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ColorPicker({
  palette,
  getPaletteFn,
  color,
  close,
  selectColor,
  isDarkMode,
  deleteStep
}) {
  const [tab, setTab] = (0, _react.useState)(color.type === 'categorical' && (color.paletteId === palette.id || color.paletteId === _neutral.NeutralPalette.id) ? 'palette' : 'custom');
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 168
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "none",
    style: {
      borderBottom: 'none'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "m",
    expand: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => setTab('palette'),
    isSelected: tab === 'palette'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('coloring.colorMapping.colorPicker.paletteTabLabel', {
    defaultMessage: 'Colors'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    onClick: () => setTab('custom'),
    isSelected: tab === 'custom'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('coloring.colorMapping.colorPicker.customTabLabel', {
    defaultMessage: 'Custom'
  })))))), tab === 'palette' ? /*#__PURE__*/_react.default.createElement(_palette_colors.PaletteColors, {
    color: color,
    getPaletteFn: getPaletteFn,
    palette: palette,
    selectColor: selectColor,
    isDarkMode: isDarkMode
  }) : /*#__PURE__*/_react.default.createElement(_rgb_picker.RGBPicker, {
    color: color,
    getPaletteFn: getPaletteFn,
    isDarkMode: isDarkMode,
    selectColor: selectColor,
    palette: palette,
    close: close
  }), deleteStep ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "danger",
    size: "xs",
    iconType: "trash",
    onClick: () => {
      close();
      deleteStep();
    },
    style: {
      paddingBottom: 8
    }
  }, _i18n.i18n.translate('coloring.colorMapping.colorPicker.removeGradientColorButtonLabel', {
    defaultMessage: 'Remove color step'
  }))) : null);
}