"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SpecialAssignment = SpecialAssignment;
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _color_swatch = require("../color_picker/color_swatch");
var _color_mapping = require("../../state/color_mapping");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function SpecialAssignment({
  assignment,
  index,
  palette,
  getPaletteFn,
  isDarkMode,
  total
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const canPickColor = true;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_color_swatch.ColorSwatch, {
    forType: "specialAssignment",
    canPickColor: canPickColor,
    colorMode: {
      type: 'categorical'
    },
    assignmentColor: assignment.color,
    getPaletteFn: getPaletteFn,
    index: index,
    palette: palette,
    total: total,
    swatchShape: "square",
    isDarkMode: isDarkMode,
    onColorChange: color => {
      dispatch((0, _color_mapping.updateSpecialAssignmentColor)({
        assignmentIndex: index,
        color
      }));
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    style: {
      marginRight: 32
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    compressed: true,
    fullWidth: true,
    disabled: true,
    placeholder: _i18n.i18n.translate('coloring.colorMapping.assignments.unassignedPlaceholder', {
      defaultMessage: 'Unassigned terms'
    }),
    "aria-label": _i18n.i18n.translate('coloring.colorMapping.assignments.unassignedAriaLabel', {
      defaultMessage: 'Assign this color to every unassigned not described in the assignment list'
    })
  })));
}