"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SPECIAL_TOKENS_STRING_CONVERTION = void 0;
exports.rangeMatch = rangeMatch;
exports.ruleMatch = ruleMatch;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function ruleMatch(rule, value) {
  switch (rule.type) {
    case 'matchExactly':
      if (Array.isArray(value)) {
        return rule.values.some(v => Array.isArray(v) && v.length === value.length && v.every((part, i) => part === value[i]));
      }
      return rule.values.includes(`${value}`);
    case 'matchExactlyCI':
      return rule.values.some(d => d.toLowerCase() === `${value}`);
    case 'range':
      // TODO: color by value not yet possible in all charts in elastic-charts
      return typeof value === 'number' ? rangeMatch(rule, value) : false;
    default:
      return false;
  }
}
function rangeMatch(rule, value) {
  return rule.min === rule.max && rule.min === value || (rule.minInclusive ? value >= rule.min : value > rule.min) && (rule.maxInclusive ? value <= rule.max : value < rule.max);
}

// TODO: move in some data/table related package
const SPECIAL_TOKENS_STRING_CONVERTION = new Map([['__other__', _i18n.i18n.translate('coloring.colorMapping.terms.otherBucketLabel', {
  defaultMessage: 'Other'
})], ['', _i18n.i18n.translate('coloring.colorMapping.terms.emptyLabel', {
  defaultMessage: '(empty)'
})]]);
exports.SPECIAL_TOKENS_STRING_CONVERTION = SPECIAL_TOKENS_STRING_CONVERTION;