"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssignmentColor = getAssignmentColor;
exports.getColor = getColor;
exports.getColorFactory = getColorFactory;
exports.getGradientColorScale = getGradientColorScale;
var _chromaJs = _interopRequireDefault(require("chroma-js"));
var _color_math = require("./color_math");
var _assignment_from_categories = require("../config/assignment_from_categories");
var _rule_matching = require("./rule_matching");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function getAssignmentColor(colorMode, color, getPaletteFn, isDarkMode, index, total) {
  switch (color.type) {
    case 'colorCode':
    case 'categorical':
      return getColor(color, getPaletteFn, isDarkMode);
    case 'gradient':
      {
        if (colorMode.type === 'categorical') {
          return 'red';
        }
        const colorScale = getGradientColorScale(colorMode, getPaletteFn, isDarkMode);
        return total === 0 ? 'red' : total === 1 ? colorScale(0) : colorScale(index / (total - 1));
      }
  }
}
function getColor(color, getPaletteFn, isDarkMode) {
  return color.type === 'colorCode' ? color.colorCode : (0, _color_math.getValidColor)(getPaletteFn(color.paletteId).getColor(color.colorIndex, isDarkMode)).hex();
}
function getColorFactory(model, getPaletteFn, isDarkMode, data) {
  const palette = getPaletteFn(model.paletteId);
  // generate on-the-fly assignments in auto-mode based on current data.
  // This simplify the code by always using assignments, even if there is no real static assigmnets
  const assignments = model.assignmentMode === 'auto' ? (0, _assignment_from_categories.generateAutoAssignmentsForCategories)(data, palette, model.colorMode) : model.assignments;

  // find auto-assigned colors
  const autoAssignedColors = data.type === 'categories' ? assignments.filter(a => {
    return a.rule.type === 'auto' || a.rule.type === 'matchExactly' && a.rule.values.length === 0;
  }) : [];

  // find all categories that doesn't match with an assignment
  const nonAssignedCategories = data.type === 'categories' ? data.categories.filter(category => {
    return !assignments.some(({
      rule
    }) => (0, _rule_matching.ruleMatch)(rule, category));
  }) : [];
  return category => {
    if (typeof category === 'string' || Array.isArray(category)) {
      const nonAssignedCategoryIndex = nonAssignedCategories.indexOf(category);

      // return color for a non assigned category
      if (nonAssignedCategoryIndex > -1) {
        if (nonAssignedCategoryIndex < autoAssignedColors.length) {
          const autoAssignmentIndex = assignments.findIndex(d => d === autoAssignedColors[nonAssignedCategoryIndex]);
          return getAssignmentColor(model.colorMode, autoAssignedColors[nonAssignedCategoryIndex].color, getPaletteFn, isDarkMode, autoAssignmentIndex, assignments.length);
        }
        // if no auto-assign color rule/color is available then use the other color
        // TODO: the specialAssignment[0] position is arbitrary, we should fix it better
        return getColor(model.specialAssignments[0].color, getPaletteFn, isDarkMode);
      }

      // find the assignment where the category matches the rule
      const matchingAssignmentIndex = assignments.findIndex(({
        rule
      }) => {
        return (0, _rule_matching.ruleMatch)(rule, category);
      });

      // return the assigned color
      if (matchingAssignmentIndex > -1) {
        const assignment = assignments[matchingAssignmentIndex];
        return getAssignmentColor(model.colorMode, assignment.color, getPaletteFn, isDarkMode, matchingAssignmentIndex, assignments.length);
      }
      // if no assign color rule/color is available then use the other color
      // TODO: the specialAssignment[0] position is arbitrary, we should fix it better
      return getColor(model.specialAssignments[0].color, getPaletteFn, isDarkMode);
    } else {
      const matchingAssignmentIndex = assignments.findIndex(({
        rule
      }) => {
        return (0, _rule_matching.ruleMatch)(rule, category);
      });
      if (matchingAssignmentIndex > -1) {
        const assignment = assignments[matchingAssignmentIndex];
        return getAssignmentColor(model.colorMode, assignment.color, getPaletteFn, isDarkMode, matchingAssignmentIndex, assignments.length);
      }
      return getColor(model.specialAssignments[0].color, getPaletteFn, isDarkMode);
    }
  };
}
function getGradientColorScale(colorMode, getPaletteFn, isDarkMode) {
  const steps = colorMode.steps.length === 1 ? [getColor(colorMode.steps[0], getPaletteFn, isDarkMode), (0, _color_math.combineColors)((0, _color_math.changeAlpha)(getColor(colorMode.steps[0], getPaletteFn, isDarkMode), 0.3), isDarkMode ? 'black' : 'white')] : colorMode.steps.map(d => getColor(d, getPaletteFn, isDarkMode));
  steps.sort(() => colorMode.sort === 'asc' ? -1 : 1);
  const scale = _chromaJs.default.scale(steps).mode('lab');
  return value => scale(value).hex();
}