"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTopVulnerabilities = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getVulnerabilitiesQuery = () => ({
  size: 0,
  query: {
    match_all: {}
  },
  index: _constants.LATEST_VULNERABILITIES_INDEX_DEFAULT_NS,
  aggs: {
    vulnerabilities: {
      terms: {
        field: 'vulnerability.id',
        order: {
          _count: 'desc'
        },
        size: 10
      },
      aggs: {
        score: {
          max: {
            field: 'vulnerability.score.base'
          }
        },
        cveVersion: {
          terms: {
            field: 'vulnerability.score.version'
          }
        },
        severity: {
          terms: {
            field: 'vulnerability.severity',
            size: 1
          }
        },
        packageFixVersion: {
          terms: {
            field: 'package.fixed_version',
            size: 1
          }
        },
        packageName: {
          terms: {
            field: 'package.name',
            size: 1
          }
        },
        packageVersion: {
          terms: {
            field: 'package.version',
            size: 1
          }
        }
      }
    }
  }
});
const getTopVulnerabilities = async esClient => {
  var _queryResult$aggregat;
  const queryResult = await esClient.search(getVulnerabilitiesQuery());
  if (!(queryResult !== null && queryResult !== void 0 && (_queryResult$aggregat = queryResult.aggregations) !== null && _queryResult$aggregat !== void 0 && _queryResult$aggregat.vulnerabilities)) return [];
  return queryResult.aggregations.vulnerabilities.buckets.map(vulnerability => {
    var _vulnerability$packag, _vulnerability$packag2, _vulnerability$packag3, _vulnerability$packag4, _vulnerability$packag5, _vulnerability$packag6, _vulnerability$packag7, _vulnerability$packag8, _vulnerability$packag9, _vulnerability$packag10, _vulnerability$packag11, _vulnerability$packag12, _vulnerability$severi, _vulnerability$severi2, _vulnerability$severi3, _vulnerability$severi4, _vulnerability$score, _vulnerability$cveVer, _vulnerability$cveVer2, _vulnerability$cveVer3, _vulnerability$cveVer4;
    return {
      cve: vulnerability.key,
      packageFixVersion: (_vulnerability$packag = (_vulnerability$packag2 = vulnerability.packageFixVersion) === null || _vulnerability$packag2 === void 0 ? void 0 : (_vulnerability$packag3 = _vulnerability$packag2.buckets) === null || _vulnerability$packag3 === void 0 ? void 0 : (_vulnerability$packag4 = _vulnerability$packag3[0]) === null || _vulnerability$packag4 === void 0 ? void 0 : _vulnerability$packag4.key) !== null && _vulnerability$packag !== void 0 ? _vulnerability$packag : '',
      packageName: (_vulnerability$packag5 = (_vulnerability$packag6 = vulnerability.packageName) === null || _vulnerability$packag6 === void 0 ? void 0 : (_vulnerability$packag7 = _vulnerability$packag6.buckets) === null || _vulnerability$packag7 === void 0 ? void 0 : (_vulnerability$packag8 = _vulnerability$packag7[0]) === null || _vulnerability$packag8 === void 0 ? void 0 : _vulnerability$packag8.key) !== null && _vulnerability$packag5 !== void 0 ? _vulnerability$packag5 : '',
      packageVersion: (_vulnerability$packag9 = (_vulnerability$packag10 = vulnerability.packageVersion) === null || _vulnerability$packag10 === void 0 ? void 0 : (_vulnerability$packag11 = _vulnerability$packag10.buckets) === null || _vulnerability$packag11 === void 0 ? void 0 : (_vulnerability$packag12 = _vulnerability$packag11[0]) === null || _vulnerability$packag12 === void 0 ? void 0 : _vulnerability$packag12.key) !== null && _vulnerability$packag9 !== void 0 ? _vulnerability$packag9 : '',
      severity: (_vulnerability$severi = (_vulnerability$severi2 = vulnerability.severity) === null || _vulnerability$severi2 === void 0 ? void 0 : (_vulnerability$severi3 = _vulnerability$severi2.buckets) === null || _vulnerability$severi3 === void 0 ? void 0 : (_vulnerability$severi4 = _vulnerability$severi3[0]) === null || _vulnerability$severi4 === void 0 ? void 0 : _vulnerability$severi4.key) !== null && _vulnerability$severi !== void 0 ? _vulnerability$severi : '',
      vulnerabilityCount: vulnerability.doc_count,
      cvss: {
        score: (_vulnerability$score = vulnerability.score) === null || _vulnerability$score === void 0 ? void 0 : _vulnerability$score.value,
        version: (_vulnerability$cveVer = (_vulnerability$cveVer2 = vulnerability.cveVersion) === null || _vulnerability$cveVer2 === void 0 ? void 0 : (_vulnerability$cveVer3 = _vulnerability$cveVer2.buckets) === null || _vulnerability$cveVer3 === void 0 ? void 0 : (_vulnerability$cveVer4 = _vulnerability$cveVer3[0]) === null || _vulnerability$cveVer4 === void 0 ? void 0 : _vulnerability$cveVer4.key) !== null && _vulnerability$cveVer !== void 0 ? _vulnerability$cveVer : ''
      }
    };
  });
};
exports.getTopVulnerabilities = getTopVulnerabilities;