"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSortedCspRulesTemplates = exports.defineFindCspRuleTemplateRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _compare = _interopRequireDefault(require("semver/functions/compare"));
var _valid = _interopRequireDefault(require("semver/functions/valid"));
var _get_csp_rule_template = require("../../../common/schemas/csp_rule_template_api/get_csp_rule_template");
var _helpers = require("../../../common/utils/helpers");
var _constants = require("../../../common/constants");
var _benchmarks = require("../benchmarks/benchmarks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSortedCspRulesTemplates = cspRulesTemplates => {
  return cspRulesTemplates.slice().sort((a, b) => {
    var _a$metadata, _a$metadata$benchmark, _b$metadata, _b$metadata$benchmark;
    const ruleNumberA = a === null || a === void 0 ? void 0 : (_a$metadata = a.metadata) === null || _a$metadata === void 0 ? void 0 : (_a$metadata$benchmark = _a$metadata.benchmark) === null || _a$metadata$benchmark === void 0 ? void 0 : _a$metadata$benchmark.rule_number;
    const ruleNumberB = b === null || b === void 0 ? void 0 : (_b$metadata = b.metadata) === null || _b$metadata === void 0 ? void 0 : (_b$metadata$benchmark = _b$metadata.benchmark) === null || _b$metadata$benchmark === void 0 ? void 0 : _b$metadata$benchmark.rule_number;
    const versionA = (0, _valid.default)(ruleNumberA);
    const versionB = (0, _valid.default)(ruleNumberB);
    if (versionA !== null && versionB !== null) {
      return (0, _compare.default)(versionA, versionB);
    } else {
      return String(ruleNumberA).localeCompare(String(ruleNumberB));
    }
  });
};
exports.getSortedCspRulesTemplates = getSortedCspRulesTemplates;
const getBenchmarkIdFromPackagePolicyId = async (soClient, packagePolicyId) => {
  const res = await soClient.get(_benchmarks.PACKAGE_POLICY_SAVED_OBJECT_TYPE, packagePolicyId);
  return (0, _helpers.getBenchmarkFromPackagePolicy)(res.attributes.inputs);
};
const findCspRuleTemplateHandler = async (soClient, options) => {
  if (!options.packagePolicyId && !options.benchmarkId || options.packagePolicyId && options.benchmarkId) {
    throw new Error('Please provide either benchmarkId or packagePolicyId, but not both');
  }
  const benchmarkId = options.benchmarkId ? options.benchmarkId : await getBenchmarkIdFromPackagePolicyId(soClient, options.packagePolicyId);
  const cspRulesTemplatesSo = await soClient.find({
    type: _constants.CSP_RULE_TEMPLATE_SAVED_OBJECT_TYPE,
    searchFields: options.searchFields,
    search: options.search ? `"${options.search}"*` : '',
    page: options.page,
    perPage: options.perPage,
    sortField: options.sortField,
    fields: options === null || options === void 0 ? void 0 : options.fields,
    filter: (0, _helpers.getBenchmarkFilter)(benchmarkId, options.section)
  });
  const cspRulesTemplates = cspRulesTemplatesSo.saved_objects.map(cspRuleTemplate => cspRuleTemplate.attributes);

  // Semantic version sorting using semver for valid versions and custom comparison for invalid versions
  const sortedCspRulesTemplates = getSortedCspRulesTemplates(cspRulesTemplates);
  return {
    items: sortedCspRulesTemplates,
    total: cspRulesTemplatesSo.total,
    page: options.page,
    perPage: options.perPage
  };
};
const defineFindCspRuleTemplateRoute = router => router.versioned.get({
  access: 'internal',
  path: _constants.FIND_CSP_RULE_TEMPLATE_ROUTE_PATH
}).addVersion({
  version: '1',
  validate: {
    request: {
      query: _get_csp_rule_template.findCspRuleTemplateRequest
    }
  }
}, async (context, request, response) => {
  if (!(await context.fleet).authz.fleet.all) {
    return response.forbidden();
  }
  const requestBody = request.query;
  const cspContext = await context.csp;
  try {
    const cspRulesTemplates = await findCspRuleTemplateHandler(cspContext.soClient, requestBody);
    return response.ok({
      body: cspRulesTemplates
    });
  } catch (err) {
    const error = (0, _securitysolutionEsUtils.transformError)(err);
    cspContext.logger.error(`Failed to fetch csp rules templates ${err}`);
    return response.customError({
      body: {
        message: error.message
      },
      statusCode: error.statusCode
    });
  }
});
exports.defineFindCspRuleTemplateRoute = defineFindCspRuleTemplateRoute;